
# Typical usage:
#
# debug_open('jaya',9000,'Engine here for debugging');
# while($_ = debug_instruction())
#  {
#   debug_reply(eval);
#  }

use Comm;

# assumes Comm is initialized




sub debug_open
{
  package Debug_hook;

  my($host,$port,$welcome) = @_;

  unless($Comm::INIT)
   {
    my ($status) = Comm::init(0,0);
    unless ($status eq 'ok')
     {
      die "Couldn't get Comm.pm init in Debug_hook.pm\n";
     }
   }
  Comm::tcp_send($host,$port,'debug',$welcome);
  $Debug_hook::host = $host;
  $Debug_hook::port = $port;
}

sub debug_instruction
{
  package Debug_hook;
  my($host,$port,$header,@body);

  while(($host,$port,$header,@body) = Comm::tcp_recv('blocking'))
   {
    return undef if $header eq 'debug_over';
    next unless $header eq 'debug';  # Drop everything else on floor
    last;
   }
  return $body[0];
}

sub debug_reply
{
  package Debug_hook;
  Comm::tcp_send($Debug_hook::host,$Debug_hook::port,'debug',$_[0]);
}

1;