
# package to store information about GrIDS configurations between runs, for
# UI etc.

package Grdbm;
srand;

# A record of what is/was actually running where:
$grdbm_location = "$ENV{'GRIDSPATH'}/user_interface/.grdbm";

#=============================================================================#

no strict 'vars';

sub new
{
  # RC 4/8/97:  deleted $number_mod_hosts and $number_init_hosts.
  # Apparent purpose was to differentiate BIGROOT vs. NO-PARM startup configs.
  # But those nums are wrong (or meaningless) until we parse @dept_geometry.

  $self = {};  bless $self;

# RC BUG 4/8/97:  is it even possible to re-use MCs under new ACL,
# unless we replicate *exact* previous geometry, including SM ports?
#
# If we do allow MCs to outlive a grids invocation, then unless we KILL
# them selectively @ each new startup, then eventually each user will
# have a MC on each host!  THAT HOGS RESOURCES!
# To learn what still lives (hence what we *may* need selectively to kill),
# perhaps the solution is to do the following in a different *package*?  ::

   if(-f $grdbm_location)
    {
     do $grdbm_location unless $ARGV[0] eq 'start';
    }
### RC 6/10/97: Ignore only on START; need it for GRIDS_DESTROY and GRIDS_CHECK!

### RC 6/16/97: Note above info is somewhat redundant with "output_hierarchy"
#   (in either user_interface/grids.tempdir, or user_interface itself).
#   However, output_hierarchy also tells host:port for each dept SM and AGG.

################################################

  $self->save();
  return $self;   ## if $_[1] == 5  &&  $_[2] == 3;
  # RC BUG KLUDGE -- should change initial call in Hierarchy_interface.pm

}


###############################################################################
# Parm files *must* define $self->{'host_to_os'} and @dept_geometry.
# Elements in personal startup config stuff (3rd parm) will override
# data from CVS standard config file, which is our 2nd parm.

sub parse_config_file {
  my ($self, $config_file, $config_overrides) = @_;

  require $config_file;
  require $config_overrides;

  # Handle and sanity-check @dept_geometry as formatted by user:
  my ($sum_hosts, $index) = (0, 0);
  foreach $dept (@dept_geometry) {
    # create a semi topological sort by departmental parentage:
    push @{$child_depts{$dept->{PARENT_DEPT}}}, $dept;
    # Must create separate global var $child_depts, because all $grids_db
    # data structs must be strings for transission via Comm.pm, else error:
    #      Bad $mesgs_ref argument in communicate_with_sms

    $self->{'dept_to_index'}{$dept->{DEPT_NAME}} = $index;

    if (exists $dept->{NUM_HOSTS}) {
      $sum_hosts += $dept->{NUM_HOSTS} -
                    ( (exists $dept->{SPECIFIC_HOSTS})  ?
                      ($#{$dept->{SPECIFIC_HOSTS}} + 1) :  0 );
      }
    ### First sanity-check semi-universal hostlists to ensure hosts exist:
    if (exists $dept->{HOST_UNIVERSE}) {
      for ($i = 0; $i < $#{$dept->{HOST_UNIVERSE}}; $i++) {
        unless (exists $self->{'host_to_os'}{$dept->{HOST_UNIVERSE}[$i]}) {
          $main::log->warn ("Removing undeclared host <"
                      . ${$dept->{HOST_UNIVERSE}}[$i]
                      . "> from HOST_UNIVERSE of dept " . $dept->{DEPT_NAME});
          splice (@{$dept->{HOST_UNIVERSE}}, $i, 1);
          }
        }
      } ## else DO NOT CREATE IT by $#{list}-DEREFERENCING it above !!!
    ### Next, sanity-check to ensure 2 depts do not claim same SPECIFIC host:
    foreach $host (@{$dept->{SPECIFIC_HOSTS}}) {
      unless (exists $self->{'host_to_os'}{$host}) {
        return "User specified non-existent host $host!  die!";
        }
      if ($self->{'host_to_dept'}{$host}) {
        return "Both depts " . $self->{'host_to_dept'}{$host} .
               " and $dept->{DEPT_NAME} claim host $host!  die!";
        }
      else {
        $self->{'host_to_dept'}{$host} = $dept->{DEPT_NAME};
        ${$self->{claimed_hosts}}{$host} = 1;
        }
      }
    ### Finally, do special stuff if dept is ROOT:
    if ($dept->{DEPT_NAME} eq 'ROOT') {
       if (defined $self->{'root_sm_host'}) {
         $dept->{SM_HOST} = $self->{'root_sm_host'};
         }
       elsif ($dept->{SM_HOST}) {
         $self->{'root_sm_host'} = $dept->{SM_HOST};
         }
       # else it may not have been specified explicitly; we must wait.

       if (defined $self->{'root_aggregator_host'}) {
         $dept->{AGG_HOST} = $self->{'root_aggregator_host'};
         }
       elsif ($dept->{AGG_HOST}) {
         $self->{'root_aggregator_host'} = $dept->{AGG_HOST};
         }
       # else it may not have been specified explicitly; we must wait.
      }
    $index++;
    }

  $self->{'root_sm_port'} = $self->new_port() unless $self->{'root_sm_port'};
  $self->{'ohs_port'} = $self->new_port() unless $self->{'ohs_port'};

## These ohs_host, etc, loading constraints may be unnecessarily harsh.
## NOTE: etc_host, may *already* have been claimed above as SPECIFIC_HOSTS.
## Also, do *not* yet $self->{'host_to_dept'}{$self->{'ohs_host'}} = 'OHS';
  if (defined $self->{'ohs_host'}) {
    ${$self->{claimed_hosts}}{$self->{'ohs_host'}} = 1;
    }
  if (defined $self->{'root_sm_host'}) {
    ${$self->{claimed_hosts}}{$self->{'root_sm_host'}} = 1;
    }
  if (defined $self->{'root_aggregator_host'}) {
    ${$self->{claimed_hosts}}{$self->{'root_aggregator_host'}} = 1;
    }


##### Notes re how to deal with holdover state ...
#   # RC BUG:: first mention of module_hosts!  Set via $grdbm_location?
#   # RC:  Shrink it too ... if not now, then it wouldn't ever happen:
#   # RC BUG:  Stupid to randomly delete -- might kill claimed_hosts!
#   while ( $#{$self->{'module_hosts'}} > $sum_hosts - 1 ) {
#     $host = splice (@{$self->{'module_hosts'}},
#                     int(rand(@{$self->{'module_hosts'}})), 1);
#     # RC BUG:: now must cleanup/destroy MC on that $host!
#     }

  push (@{$self->{'module_hosts'}}, keys %{$self->{'host_to_dept'}});
  foreach $key (keys %{$self->{'host_to_os'}}) {
    push (@{$self->{'unclaimed_hosts'}}, $key)
      unless exists ${$self->{claimed_hosts}}{$key};
    }  # we build a list vs. hash here solely to allow *rand* host selection.

  die "Too few hosts remain: $sum_hosts vs. $#{$self->{'unclaimed_hosts'}}!\n" 
	unless $sum_hosts <= $#{$self->{'unclaimed_hosts'}} + 1;
  ### RC: need to cleanup/destroy/recover above; not just die?

  $self->save();
  return $self;
} ####################### parse_config_file ##################################


### Call this with 3rd parm == *REF* to list; eg, \@{$dept->{HOST_UNIVERSE}}
sub select_hosts {
  my ($self, $num_to_pick, $universal_list, $dept_name) = @_;
  my (@picks, $host);

  ### RC 6/17/97: rewrote &select_hosts() for efficiency.
  while ($#picks < $num_to_pick - 1) {
    last unless @{$universal_list};
    $host = splice (@$universal_list, int(rand(@$universal_list)), 1);
    next if (exists ${$self->{claimed_hosts}}{$host});
    # else it's still unclaimed_host, and/or not yet tested as unsuitable ...

    unless ( $self->ping_ok ($host) ) {
      warn ("SELECTED HOST $host FAILED to \&ping_ok.\n");
      $main::log->warn ("SELECTED HOST $host FAILED to \&ping_ok.\n");
      ${$self->{claimed_hosts}}{$host} = 0;
        # Permanently remove even if only *provisionally* claimed;
        # if that host fails for another dept, it's also useless to us.
      next;
      }
    unless ( $self->fork_swap_ok ($host) ) {
      warn ("SELECTED HOST $host FAILED to \&fork_swap_ok.\n");
      $main::log->warn ("SELECTED HOST $host FAILED to \&fork_swap_ok.\n");
      ${$self->{claimed_hosts}}{$host} = 0;
        # Permanently remove even if only *provisionally* claimed;
        # if that host fails for another dept, it's also useless to us.
      next;
      }

    push (@picks, $host);
    ${$self->{claimed_hosts}}{$host} = 1;

    ### RC BUG??? $self->{'host_to_dept'}{$host} = $dept_name;
    ### Not yet; it still might fail to start its module controller.

    # Do *not* traverse entire @{$self->{unclaimed_hosts}} to delete $host;
    # Instead, delete it only if/upon randomly hitting it on subsequent splice.

    }

  return @picks;

} ####################### select_hosts ##################################


  ####################### remove_mc_from_listref ########################
### RC 6/17/97:  This func no longer called.  Its functionality was rolled into
###              &select_hosts(), which now uses far more efficient algorithm.
###
### Call this with 2nd parm == *REF* to list; eg, \@{$dept->{HOST_UNIVERSE}}
### Prune parm to remove any claimed_hosts from a 'HOST_UNIVERSE' list:
sub remove_mc_from_listref {
  my ($self, $listref, $provisional_hosts) = @_;
  my (%tmp, $changes);

  foreach $host (@$listref) {
    if ( exists $self->{'host_to_dept'}{$host}  ||
         exists $provisional_hosts->{$host} ) {   # should *not* be both!
      # Use hash slice assignment to initialize it first time:
      @tmp{@$listref} = (1) x @$listref  unless $changes;
      delete $tmp{$host};
      $changes = 1;
      }
    }

  @$listref = (keys %tmp)  if $changes;   # transfer hash to list.

} ####################### remove_mc_from_listref ########################



sub empty
{
  unlink $grdbm_location;
}

sub reduce_to_modules
{
  my($self) = @_;
  foreach $key (keys %$self)
   {
    unless($key eq 'module_hosts' || $key eq 'module_ports') {
      delete $self->{$key};}
   }
  $self->save();
}


# Print the database out as Perl so we can easily read it.

sub save
{
  my($self) = @_;
  open(GRDBM,">$grdbm_location") || die "Couldn't get $grdbm_location\n";
  print GRDBM "package Grdbm;\n\n";
  my $key;
  foreach $key (sort keys %$self)
   {
    next if $key eq 'host_to_os';
    my $code = '$self->{\''.$key.'\'}';
    if(ref eval $code) {
      $self->save_refs($code);}
    else
     {
      # it better be a scalar!
      $self->save_scalars($code);
     }
   }
  print GRDBM "1;\n";
  close(GRDBM);
}

# Internals from here on out.  Do not call from outside.

sub save_scalars
{
  my($self,@values) = @_;
  foreach (@values)
   {
    print GRDBM "$_ = '".eval($_)."';\n\n" if(defined eval);
   }
}

sub save_refs
{
  my($self,@values) = @_;
  foreach $val (@values)
   {
    my $ref = eval($val);
    next unless defined $ref;
    if(ref $ref eq 'ARRAY')
     {print GRDBM "$val = ['".join('\',\'',@$ref)."'];\n\n";}
    elsif(ref $ref eq 'HASH')
     {print GRDBM "$val = {'".join('\',\'',%$ref)."'};\n\n";}
    else
     {die "Bad key $val passed to Grdbm::save_refs.  Type ".ref $ref.".\n";}
   }
}

sub new_port
{
  return 7000 + int(rand(23000));
}

###############################################################################
###############################################################################

sub ping_ok {
  my ($self, $host, $verbose) = @_;
  $max_ping_delay = 1 unless $max_ping_delay;  # 1st-order responsiveness test
  unless ($uname) {
      $res = `/bin/uname` if ( -e "/bin/uname" );
      $res = `/usr/bin/uname` if ( -e "/usr/bin/uname" );
      $uname = 'ultrix' if $res =~ /ULTRIX/i;
  }
  if ( defined($uname) && ($uname eq 'ultrix') ) {
      return 1 if &ultrix_ping($host);
  }
  else {
      return 1 if `ping $host $max_ping_delay` =~ /is alive/;
  }
  $main::errmsg = " failed to ping ok\n";
  return 0;
}


sub ultrix_ping {
  # integrated with &catch_alarm() since ultrix doesn't allow ping timeout arg
  my $host = $_[0];
  my $A_ok = 7; my $res;
  $ping_sleep = 0.02 unless $ping_sleep;
  $max_ping_delay = 2 if $max_ping_delay < 2;   # CSIF decs are *slow*!
  if ($ping_child_pid = fork) {    # $ping_child_pid must be a GLOBAL
    # Parent waits $max_ping_delay sec for child to ping $host
    # But first ensure child gets CPU:
    select (undef, undef, undef, $ping_sleep);
    alarm ($max_ping_delay + 1);   # forking requires extra time
    waitpid $ping_child_pid, 0;
    # Return STATUS is '$?'; high byte is supplied by child; low byte by system
    $res = $? >> 8;
    # print "Child's exit status (high byte) ==> <$res>\n";
    return 1 if $res == $A_ok;
    return 0;
    }
  elsif (defined $ping_child_pid) {
    exit $A_ok if `ping $host` =~ /is alive/;
    exit 3;
    }
  }



# RC 6/19/97:  For efficiency, *all* rsh probes (including final MC launch)
#              should be rolled into a single RSH command.
sub fork_swap_ok {
  my ($self, $host, $verbose) = @_;
  my $verbose = $main::rcdbg  ||  0  unless $verbose;    # RC BUG debugging
  return 0 unless $self->swap_ok ($host, $verbose);
  return 0 unless $self->fork_ok ($host, $verbose);
  return 1;
}



sub fork_ok {
  return 1 unless $do_fork_test;
  $num_forks_tried = 2 unless defined $num_forks_tried;
  return 1 if $num_forks_tried <= 0;
  $max_fork_time = 1 unless $max_fork_time;
  my ($self, $host, $verbose) = @_;
#
# Running on non-UCDseclab environments ( perl binaries not in /pkg/bin ) may
# require a PERLLOC environment variable to point explicitly to the perl
# binary.  If so the following comment line must be manipulated. JRowe 2/9/98
#
  my $cmd = "\\\$PERLLOC/perl -w \\\$GRIDSPATH/common/forks_ok.pl "
#  my $cmd = "\\\$GRIDSPATH/common/forks_ok.pl "
          . "$verbose $num_forks_tried $max_fork_time";
#
  my $res = `rsh $host "$cmd"`;
  print $res if $verbose;
  return 1 if $res =~ 'OK';
  $main::errmsg = " failed to fork ok\n";
  return 0;
  }


sub swap_ok {
  return 1 unless $do_swap_test;
  $min_avail_swap = 24000 unless defined $min_avail_swap;    # heuristic guess
  return 1 if $min_avail_swap <= 0;
  my ($self, $host, $verbose) = @_;
  my ($avail, $res);
  if ($self->{'host_to_os'}{$host} =~ /solaris/i) {
    $res = `rsh $host "/usr/sbin/swap -s"`;
    }    #            "swap -s"  only installed on solaris
  if ( $self->{'host_to_os'}{$host} !~ /solaris/i  ||  $res !~ /\d+/ ) {
    return &df_swap_ok ($host, $verbose);
    }

  ($avail) = ($res =~ / (\d+)k available/);

  warn ("$host:  Enough swapspace AVAILABLE?  $avail  >?  $min_avail_swap ?\n")
    if $verbose;

  return 1 if $avail >= $min_avail_swap;
  $main::errmsg = " failed to swap ok\n";
  return 0;
  }



sub df_swap_ok {
  my ($host, $verbose) = @_;
  my $res = `rsh $host "df" | grep swap`;
  my @lines;

  foreach (split ("\n", $res) ) {
    push (@lines, $_) if /\bswap\b|\bswapfile\b/;
    }
  unless ($#lines == 0) {
    print STDERR "Avoiding $host; unable to find its swap device.\n";
    return 0;
    }

  # FORMAT:: Filesystem            kbytes    used   avail capacity  Mounted on
  my ($fs, $avail, $capacity, $mount) = $lines[0] =~
               /^(\S+)\s+\d+\s+\d+\s+(\d+)\s+(\d+)%\s+(\S+)/;
 #print
 #  "$host: (fs, avail, capacity, mount) = ($fs, $avail, $capacity\%, $mount)\n"
 #  if $verbose;

  $capacity_max = 90;     # heuristic guess; see table below

  print
   "$host:  Enough swapspace AVAILABLE?  $avail  >?  $min_avail_swap?\n"
    if $verbose;

  return 1 if $avail > $min_avail_swap;    ##  &&  $capacity < $capacity_max;
  $main::errmsg = " failed to swap ok\n";
  return 0;
  }



1;

