
# Package to use gettimeofday for code timing.

# &start_timing('mykey');

use Stat_summary;

sub start_timing
{
  package Timing;
  if($in_progress{$_[0]})
   {
    warn "Start_timing repeat for $_[0]\n";
    return;
   }
  syscall(&SYS_gettimeofday, $arg1, $arg2);
  ($secs,$usecs) = unpack("ll",$arg1);
  $in_progress{$_[0]} = [$secs,$usecs];
}

# &stop_timing('mykey');

sub stop_timing
{
  package Timing;
  unless(defined $in_progress{$_[0]})
   {
    warn "Stop_timing on non-existent key for $_[0]\n";
    return;
   }
  syscall(&SYS_gettimeofday, $arg1, $arg2);
  ($secs,$usecs) = unpack("ll",$arg1);
  ($old_secs,$old_usecs) = @{$in_progress{$_[0]}};
  $in_progress{$_[0]} = '';
  $diff = ($secs - $old_secs)*1000000;
  $diff += $usecs - $old_usecs;
  push @{$results{$_[0]}},$diff;
}

# &output_timing($filename);

sub output_timing
{
  package Timing;
  open(FILE, ">>$_[0]") || die("Couldn't open $_[0]\n");
  foreach $key (keys %results)
   {
    $mystat = new Stat_summary();
    $mystat->observe(@{$results{$key}});
    $mean = $mystat->mean();
    $error = $mystat->mean_err();
    printf FILE "%s\t%.0f +- %.0f;\t",$key,$mean,$error;
    print FILE join(" ",@{$results{$key}},"\n");
   }
  close(FILE);
}

package Timing;

unless(eval "require 'syscall.ph'")
 {
  # default value for BSD like systems (eg Sunos 4 and NeXTstep).
  sub SYS_gettimeofday {116;}
 }

$arg1 = "aaaaaaaa";
$arg2 = "aaaaaaaa";

