#!/pkg/bin/perl -w

# This is a simple auto-test-shell to exercise the self-pruning logfiles.
# For more complex test cases, invoke &interact();


use control_vars;
$rvars = control_vars->new ();

$rvars->{'module'} = "data.source";
$rvars->{'department'} = "Dummy_dept";

# kludge for testing:
$PRUNETEST_MAX_LOGFILE_SIZE = 40;
$PRUNETEST_MIN_LOGFILE_SIZE = 10;
$prunetest_filecheck_modulus = 2;

use Clog;
$c_log = new Clog ($rvars->{'module'},
                   $rvars->{'department'}, "prunetest");

$rvars->{'max_logfile_size'} = 20;
$rvars->{'min_logfile_size'} = 5;
  # defining these will override above default vals.

#  new Clog already autoprinted a lengthy header.
$c_log->warn ("1234567890");
$c_log->warn ("ABCDEFGHIJ");

$contents = '';
open (LOG, "<$ENV{'GRIDSPATH'}/log/prunetest");
read (LOG, $contents, 100);
if ($contents eq "7890\nABCDEFGHIJ\n") {
  print "\nPRUNETEST worked ok\n";
  }
else {
  print "\nPRUNETEST failed::  <$contents> instead of <7890\\nABCDEFGHIJ\\n>\n";
}

##################################

sub interact {
  for (;;) {
    print "######### Enter junk for logfile: ";
    $in = <STDIN>;
    $c_log->warn ($in);
    $len = length ($in);
    print "######### Added $len more chars to logfile\n";
    }
  }

1;

