#!/pkg/bin/perl -w

# INVOKE from Unix  (to test Dan's control var pkg):
#                   data.source.pl dat.prefix dat.init dept_CS k2:9999

# data.source.pl
# is a generic dumb data source template.
# It helps test whether module controller correctly creates its STARTUP TASKS,
# and whether they understand their initial parms
# (an $init_file and a $path_prefix for their workspace).
# It also tests Dan's control var stuff.


$| = 1;       # unbuffer STDOUT
($path_prefix, $init_file, $dept_ID, $host_port) = @ARGV;

print "######### dummy data.source test stub here; my PID = <$$>\n";
print "######### \$dept_ID = <$dept_ID>; \$host_port = <$host_port>\n";
print "######### \$init_file = <$init_file>; \$path_prefix = <$path_prefix>\n"
        . "\n";

####################################################################
$debug{'proc'} = 0;      # makes SIGHANDLER in control_vars.pm verbose
$debug{'verbose'} = 0;      # internal verbosity

use control_vars;
$vars = control_vars->new ();

# Important to load "standard" control vars:
$vars->{'module'} = "data.source";
$vars->{'version'} = "v.FOO";        # although this one is usually ignored.
#  $vars->{'department'} = "$dept_ID";
# now done automagically by control_vars->new()

use Comm;
  {
  local $fname = "FREEPORT";
  local $increment = 1;
  $MY_TCP_PORT = do "freeport.pl";
  }               # to make certain we don't bind to a port already in use.
($MY_UDP_PORT, $MAX_CLIENT) = (undef, 5);   # (for example)
&Comm::init ($MY_TCP_PORT, $MY_UDP_PORT, $MAX_CLIENT);
use Clog;
$c_log = new Clog ($vars->{'module'},
                    $vars->{'department'}, "dumb.errlog");
$c_log->{'prefix'} = " (PID$$) ";

# NOTE::  control_vars.pm *ASSUMES* your module accesses Clog via "$my_log"!
# Its routine, &do_set(), may need to invoke ===>  $main::my_log->warn()
# But if you access Clog via some other varname, it will still find it.


# create (& initialize) semi-standard control vars:
$vars->add_straight ("listen_tcp");
$vars->{'listen_tcp'} = 7890;

# create & initialize our own "customized" control vars:
$vars->add_straight ("var1", "var2");
$vars->{'var1'} = "Var One";
$vars->{'var2'} = "Var Two";

$vars->add_indexed ("ind1", "ind2");
$vars->{'ind1'}{1} = "Index 1-1";
$vars->{'ind1'}{2} = "Index 1-2";

# Write them to our status file:
$vars->update();

# &make_cmd();
# exit;

for (;;) {
  print "######### data.source <$$> will await its command file\n"
    if $debug{'verbose'};
  # Wait for command:
  $block = 1; # block waiting for a cmd file?
  $cmd = $vars->get_command ($block);
  print "######### data.source <$$> *received* its command file ===> ",
        "[$path_prefix.cmd]\n"  if $debug{'verbose'};

  # This routine implements simple assignment to SET control vars:
  #&control_vars::do_set (*cmd, *vars) if $cmd->{'command'} =~ /SET/i;
  $vars->do_set (*cmd, *vars) if $cmd->{'command'} =~ /SET/i;

  $vars->{'command'} = 'OK' if $cmd->{'command'} =~ /GET/i;

  # Write changes to our status file:
  $vars->update();

  $vars->complete_command();  # unlinks the command file
  }

##################################
### This was an initial stub back when we pretended to receive a cmd.
sub make_cmd {
  $pkt = new control_vars ("junk");
  $pkt->{'command'} = "SET";
  $pkt->{'module'} = $vars->{'module'};
  $pkt->{'version'} = $vars->{'version'};
  $pkt->{'department'} = $vars->{'department'};

  $pkt->add_straight ("var1", "var2",         "var99");
  $pkt->{'var1'} = "Var One CHANGED !";
  $pkt->{'var2'} = "Var Two CHANGED !!";
  $pkt->{'var99'} = "THIS VAR WAS NEVER DEFINED IN TARGET !!!";

  $pkt->add_indexed ("ind1", "ind2",          "ind99");
  $pkt->{'ind1'}{1} = "Index 1-1 CHANGED !";
  $pkt->{'ind1'}{2} = "Index 1-2 CHANGED !!";
  $pkt->{'ind2'}{'NEW'} = "Index 2 *INITIALIZED* via SET CMD !!";

  $pkt->{'ind99'}{99} = "THIS INDEX VAR WAS NEVER DEFINED IN TARGET !!!";
  $pkt->{'ind99'}{999} = "THIS INDEX VAR WAS NEVER DEFINED IN TARGET !!!";


  $out_cmd = $pkt->encode();
  $path = "$path_prefix.cmd";
  open (PATH, ">$path") || die "Unable to open COMMAND file [$path]\n";
  print PATH $out_cmd;
  close (PATH);
  }
##################################
