#!/pkg/bin/perl -w

# $Id: data_struct.pl,v 1.6 1997/02/01 20:13:18 hoagland Exp $

# This file contains functions that do handy things with built-in perl
# data structures.

# split_list_to_hash uses a test to split each of several strings in a
# list into a hash which is returned. Each string is the list is split
# into two pieces in the first place possible according to the test
# provided.  The first piece becomes a key in the hash, and 
# the second piece becomes the associated value.  The test is used in a 
# call to split.  
#
# split_list_to_hash: test x string x string x ... -> hash
#
# e.g. %hash= &split_list_to_hash('\s+',@strings)
#
sub split_list_to_hash {
  my($test,@list)= @_;
  my(%hash);

  foreach (@list) {
    ($key,$val)= split($test,$_,2);
    $hash{$key}= $val;
  }
  return %hash;
}


# clean_hash uses a regular expression as a removal test to return a
# new hash based on a given one. The regular expression is a string to
# be put inside a pair of /'s and run over all the keys of the hash,
# those that evaluate to false appear in the outgoing hash.
#
# clean_hash: test x hash -> hash
#
# e.g. %clean_hash= &clean_hash('^_',%hash)
#
sub clean_hash {
  my($regex,%hash)= @_;

  foreach (keys %hash) {
    delete $hash{$_} if /$regex/;
  }
  return %hash;
}

1;
