#!/pkg/bin/perl -w

    # $Id: forks_ok.pl,v 1.2 1998/02/17 19:42:18 rowe Exp $

# quick heuristic invoked by common/Grdbm::forks_ok()
# to determine whether or not to site grids procs on a host.

# Doing an exec vs. simple fork *might* cause a new
# memory-intensive perl interpreter to be started up, giving us
# a realistic measure of system resources other than mere process slots.
# (eg, kanab, with allegedly 155884k of swap, would fail forks with
#  $! eq "Not enough space".

# use Comm;     # not really, but it should load up memory ;-)

select STDOUT;
$| = 1;
$verbose = $ARGV[0] || 0;
print "Fork here ; pid == $$\n" if $verbose > 1;

$hostname = `/bin/uname -n` if ( -e "/bin/uname" );
$hostname = `/usr/bin/uname -n` if ( -e "/usr/bin/uname" );
chomp $hostname;

$killvars = `cat $ENV{'GRIDSPATH'}/common/forktest.killvars`;
die "$hostname: Forktest KILL-var" if $killvars =~ /$hostname/;   # for testing

$MAXKIDS = 10;
if (defined $ARGV[1]) {
  $num_forks_tried = $ARGV[1] < $MAXKIDS ? $ARGV[1] : $MAXKIDS;
  }
else {
  $num_forks_tried = 2;     # default heuristic
  }

if (defined $ARGV[2]) {
  $max_fork_time = $ARGV[2];
  }
else {
  $max_fork_time = int ($num_forks_tried/2 + 0.5);  # BUG/KLUDGEy load heuristic
  }


@kids = ();
$time1 = time;
for ($i = 0; $i < $num_forks_tried; $i++) {
  &myfork ("$ENV{'GRIDSPATH'}/common/forks_ok.pl $verbose 0");
  ### To prevent infinite forking, make sure to define as 0 $ARGV[1] above !!!
  push (@kids, $child) unless $child == 0;
  # don't break out, since failed fork may be temporary problem.
  select (undef, undef, undef, 0.1);   # force context switch to load child
  last if time - $time1 > $max_fork_time;
  }
$timediff = time - $time1;

if (defined $ARGV[1]  &&  0 eq $ARGV[1]) {   # we wait to be killed
  while (1) {
    sleep 1;
    }
  }
# else we are the parent, so continue ...

$deaths = 0;
foreach $kid (@kids) {
  $deaths += kill ('SIGKILL', $kid);
  }


if ($deaths == $num_forks_tried && $timediff <= $max_fork_time) {
  print "\t\t <$hostname> forks OK -- spawned $num_forks_tried perl procs in ",
        $timediff, " seconds\n"
  }
else {
  print "<$hostname> forks FAILED -- spawned only $deaths of $num_forks_tried "
     . "perl procs in ", $timediff, " seconds\n";
  }

#######################################################################

sub myfork {
  my ($command) = $_[0];
  if (($child = fork()) == 0) { # child process
    return $! unless (defined $child);   # fork failed

#
# Running on non-UCDseclab environments ( perl binaries not in /pkg/bin ) may
# require a PERLLOC environment variable to point explicitly to the perl
# binary.  If so the following comment line must be manipulated. JRowe 2/9/98
#
    unless ( exec ("$ENV{PERLLOC}/perl -w $command") ) {
#    unless ( exec ("$command") ) {
      die $!;
      # can't have unemployed children running around loose !-)
      }
    }
  else {   #parent proc
    return $child;
    }
  }




1;

