#!/pkg/bin/perl -w

# $Id: Node.pm,v 1.6 1997/02/01 20:17:33 hoagland Exp $

# This file contains the Node class and methods.

use GraphObj;

# Node's are nodes in a Graph

package Node;   
use strict 'refs';

@ISA= qw(GraphObj);

# Node::new creates a new Node with the given id, and attributes
#
# new: class x id x {attr_name x val} -> Node
#
# e.g. $node= Node->new($id,'a' => 'b', 'c' => 'd');
#
sub new {
  shift;
  return bless GraphObj->new(@_,'name' => $_[0]);
}

#########

# Node::duplicate creates and returns a new Node with the same id and
# attributes as this Node;
#
# Node::duplicate: Node -> Node
#
# e.g. $node2= $node->duplicate();
#
sub duplicate {
  my($self)= shift;
  return Node->new($self->id,$self->attr_hash);
}

#######

# Node::merge_auto_computed sets the res attributes in terms of the
# cur attributes and those of a given new one for auto-computed
# attributes.  It is called at the time that the node combining rules
# are being on the nodes. This just copies the 'name' attribute over
# from cur to res, ignoring the new one entirely.
#
# merge_auto_computed: Node x Node ->
#
# e.g. $node->merge_auto_computed;
#
sub merge_auto_computed {
  $_[0]->res_attrs->set_attr('name' => $_[0]->attr_val('name'));
}

# Node::auto_computed_to_res moves the auto-computed attribute of
# the Node (namely 'name') to the res attributes.
#
# auto_computed_to_res: Node ->
#
sub auto_computed_to_res {
  my $self=shift;
  $self->res_attrs->set_attrs('name' => $self->attr_val('name'));
}

1;
