#!/pkg/bin/perl -w

# $Id: engine.pl,v 1.36 1998/02/17 19:39:58 rowe Exp $

use Network;
use Clog;
#require "dump.pl";

$use_stub_rulesets= 1; # look for rulesets on command line?
$use_local_logging= 1; # have clog report to a local file

$fasttime= 0; # use a relative clock rather than the system clock; not waiting
$nobuffer= 0; # bypass the alpha, beta and gamma buffers
$stop_if_clear= 0; # if there is no input and there is nothing buffered then exit

$compress_alerts=0; # should alerts being sent to a file be piped through gzip and given an .gz suffix?

$debug{'proc'} = 1;

sub new_rulesets {
  my(%rulesets)= @_;
  foreach $rsname (keys %rulesets) {
    $rstext= $rulesets{$rsname};
    $cvars->{'rulesets'}{$rsname} = $rstext;
    &log_ruleset_change($rsname,$rstext);
    Ruleset->new_rules($rsname,$rstext);
    Buffer::new_ruleset($rsname);
    print "$rsname is now running\n" if $DEBUG;
  }
}

# override die and warn to use Clog's
use subs qw(die warn); # hide built-in die and warn in favor of our own
sub die {
  $::clog->die($_[0]) if $clog;
  CORE::die($_[0]);
}
sub warn {
  if ($clog) {
    $::clog->warn($_[0]);
  } else {
    CORE::warn($_[0]);
  }
}

  
# was the engine started by the module controller?
$mc_started= defined($ENV{'GRIDS_STARTER'}) &&
             $ENV{'GRIDS_STARTER'} eq 'module_controller';
print "Engine running under module controller\n" if $mc_started;

####

# should we do changes to control variables only through the control
# variables package or through the SIGUSR2 invoked editor?
# I.e. should we use defaults (as modified by the command line) to set
# up our environment?  We must in the case of being stated by the
# module controller.  No is the default otherwise.
$pure_cvs= $mc_started ? 1 : 0;

# some default internal flags (i.e. not c.v.'s)
# $DEBUG=1;
$DEBUG=0;     # Changed by J.Rowe to avoid filling up the /tmp directory
              # with engine messages during long term running. 8/14/97
$DUMPSIZE= 1;

# set up version number
$VERSION= '$Revision: 1.36 $ '; # should be filled in by RCS
$VERSION=~ s/^\$Revision:\s*//;
$VERSION=~ s/[\$\s]+$//;

# some defaults for initial control variables (assuming $pure_cvs is/will be
# false)
$suffix= '.cs.ucdavis.edu';

$UI_host= 'k2'; # default user interface
$UI_port= 7600;
$children= 'sierra,lhotse,tallac';
$AGGREGATOR= '';
$DEPARTMENT= 'security lab';
$INIT_FILE= '';
$COMMAND_FILE_PREFIX= 'engine.commands';
$SETUP_FILE= '';
$beta=undef;

#########

print '@ARGV=(',join(', ',@ARGV),")\n" if $DEBUG;

if ($mc_started) {
  ($COMMAND_FILE_PREFIX,$INIT_FILE,$DEPARTMENT,$AGGREGATOR)= @ARGV;
} else {
  # allow setting of variables from command line
  foreach (@ARGV) {
    if (/=/) {
      ($name,$val)= split('=',$_);
      eval "\$".$name.'= "'.$val.'";';
    } elsif (/^-simu/) { # simulation mode
      $nobuffer=1;
      $fasttime=1;
      $stop_if_clear=1;
    } else {
      push(@FILES,$_);
    }
  }
}

$SIG{'USR2'}= 'its_cvc_time';
print "run 'kill -USR2 $$' to put engine in control variable edit mode\n";
print '-' x 79, "\n";


if ($fasttime) {
  require 'simulate.pl';
  print "internal psuedo-clock in use instead of system clock\n";
}
print "buffers are bypassed\n" if $nobuffer;
print "stopping when there is no input and there is nothing buffered\n" if $stop_if_clear;

# Note: initializing different parts of the engine needs to be done in
# certain order in order for everything to be available to different
# parts; take care when rearranging.

# we need to get the department out of the setup file now
if ($SETUP_FILE) {
  !(-e $SETUP_FILE) && die "setup file $SETUP_FILE does not exist";
  $setup_file_text= cat($SETUP_FILE);
  $DEPARTMENT=$1 if $setup_file_text =~ s/^\s*department\s*=\s*(.*)\s*//;
  $DEPARTMENT=$1 if $setup_file_text =~ s/\n\s*department\s*=\s*(.*)//;
}

# department, version, command file, and status file should be set up
# by this point
print "COMMAND_FILE_PREFIX= $COMMAND_FILE_PREFIX\n";
print "INIT_FILE= $INIT_FILE\n";
print "DEPARTMENT= $DEPARTMENT\n";
print "VERSION= $VERSION\n";

# set up $clog central logging object.  This needs the department name.
if ($use_local_logging) {
  $::clog=
Clog->new('engine',$DEPARTMENT,
          "$ENV{'GRIDSPATH'}/module_controller/engine.$DEPARTMENT.$$");
} else {
  $::clog= Clog->new('engine',$DEPARTMENT);
}
$::clog->{'stderr'}= 0;

# die and warn are safe to use now that $clog has been set up

# set up rules to work; requires user-defined functions files to load in
$fnfilebase= "$ENV{'GRIDSPATH'}/rule_functions";
@fn_files=();
opendir(RF,$fnfilebase) || die "could not open rule_functions directory to get functions";
while ($file=readdir(RF)) {
  push(@fn_files,"$fnfilebase/$file") if $file =~ /\.p[^.]*$/;
}
close RF;
print "rules functions are going to be read in from: ",join(',',@fn_files),"\n";
&execute::init(@fn_files);


# set up communications; die and warn should be working at this point
($status,$listen_tcp,$listen_udp)= &Comm::init(0,0);
die "problems starting up Comm: $status" unless $status eq 'ok';

# if command line specifies a file for Comm to read from, tell Comm
if(defined($INPUT_FILE) && $INPUT_FILE) {
  print "simulated network input coming from $INPUT_FILE\n";
  &Comm::read_file($INPUT_FILE);
}

# create the control variables object, $cvars. This depends on the
# department, version #, command, aggregator, status files,
# listen_tcp and listen_udp.  May also invoke ruleset creation.
&Network::initiate_control_vars ($COMMAND_FILE_PREFIX, $INIT_FILE,
                                $VERSION, $DEPARTMENT, $AGGREGATOR,
                                           $listen_tcp, $listen_udp);

# announce the ports we're listening on
print "engine running on UDP port $listen_udp, TCP port $listen_tcp\n";

$::cvars->update;
 # RC 8/9: risky to do this both here and &Network::initiate_control_vars();
 # Which update will MC get?  If it misses first update and bLOCKs waiting
 # for 2nd update, that could return mistaken idea of hang/timeout error.
 # Presumably that window is tiny compared to time spent processing rulesets.




# start debugging logging. the version numbers and control variable
# reported probably needs to be refined
&start_logging(time,['engine.pl',$VERSION],[%{$::cvars},
              'listen_udp',$listen_udp,'listen_tcp',$listen_tcp]);

# set up signals to be caught
sub sigcatch {
  warn "engine caught $_[0], exiting quickly but gracefully\n";
  &shutdown;
}

sub shutdown {
  &Comm::shutdown;
  &stop_logging(time);
  $::cvars->shutdown if defined($cvars);
  exit;
}

foreach $sig (qw(KILL QUIT INT TERM)) { $SIG{$sig}= 'sigcatch';}
sub sigcatch3 { &Network::print_cvs }
$SIG{'HUP'}= 'sigcatch3';

# set up buffers; should be done after $::cvars is set up
&Buffer::init_buffer;

#######
if ($SETUP_FILE) { # read control variable setup from a file
  &handle_cvc_text($setup_file_text);
} elsif (!$pure_cvs) {
  # set up control variable defaults unless $pure_cvs is true
  print '-' x 79, "\n";
  print "setting up control variables to indicated values\n";
  # set up initial rulesets
  if ($use_stub_rulesets) {
    print "using rulesets from command line (",join(',',@FILES),")\n";
    foreach $file (@FILES) {
      $rules= '';
      open(F,"<$file") || die "could not open $file";
      $rules.= $_ while (<F>);
      close F;
      $name= $file;
      $name =~ /([^\/]+)(\.rs)?$/;
      $name= $1;
      if (@errors=&check_ruleset($rules,1)) {
	print "ruleset $name errors: ",join("\n> ",'',@errors),"\n";
      } else {
	&Network::handle_control_vars('rulesets' => {$name => $rules});
      }
    }
  }
  # set up children
  @children= map($_.$suffix,split(',',$children));
  %children= ();
  foreach (@children) {
    $children{$_}= 1;
  }
  &Network::handle_control_vars('children' => \%children);
  # set up others
  &Network::handle_control_vars
           ('alert_recipients' => {$UI_host.':'.$UI_port => 1},
		      'beta' => $beta);
  &Network::print_cvs;
}

print '-' x 79, "\n";
warn( "engine ready");
########

################# Main event loop ##################

# hopefully we will have some rulesets before we receive too many reports
$cvc_pending= 0;
while(1) {
#
# The following was removed by J.Rowe 12-June-97, to reduce the size of
# the output file written to the /tmp directory.
#
#  print "Trying to receive (time=",&{$Timeout::get_timeref},")\n";
  &Network::receive;
  if ($cvc_pending) { # USR2 was received; go to cvc mode
    &do_cvc;
    $cvc_pending=0;
  }
}

sub cat {
  my($text)= '';
  open(CAT,"<$_[0]") || (warn "could not open $_[0] for read" && return undef);
  $text.= $_ while (<CAT>);
  close CAT;
  return $text;
}

sub handle_cvc_text {
  my($line,$name,$value);
  my(%delta)= ();
  foreach $line (split("\n",$_[0])) {
    my($name,$value)= split(/\s*=\s*/,$line,2);
    if ($value =~ /^\(([^\)]*)\)\s*$/ || $value =~ /^\{([^\)]*)\}\s*$/) {
      # (a,b,c) and {a,b,c} are shorthand for a set of indexed control
      # variables who value is 1
      $value= {};
      foreach (split(/\s*,\s*/,$1)) {
	if (s/\s*\.\.\s*(\S+)\s*$//) { # range specified
	  foreach ($_ .. $1) {
	    $value->{$_}=1;
	  }	
	} else {
	  $value->{$_}=1;
	}
      }
    } elsif ($value =~ /^<([^>]*)>\s*$/) { # inline a file
      $value= &cat($1);
      die "could not read $1 to inline" unless defined($value);
    }
    if ($name =~ /^(\w+)\s*\{['"]*([^\}'"]+)['"]*\}$/) {
      $delta{$1}{$2} = $value;
    } else {
      $delta{$name} = $value;
    }
  }
  &Network::handle_control_vars(%delta);
}

sub its_cvc_time {
  $cvc_pending=1;
}
  
sub do_cvc {
  print '-' x 79, "\n";
  my %delta=();
  my($in);
  my($text)= '';
  print "Enter control variables to change terminated by a blank line or a\n",
        "? for a full listing.  Files can be inlined by putting\n",
        "\"<\" and \">\" around a file name.\n";
  print "> ";
  while ($in= <STDIN>) {
    if ($in =~ /^\?\?\s*/) {
      &Network::print_cvs(1);
      last;
    }
    if ($in =~ /^\?\s*/) {
      &Network::print_cvs;
      last;
    }
    last unless $in && $in !~ /^\s*$/;
    $text.= $in;
    print "> ";
  }
  &handle_cvc_text($text);
  print '-' x 79, "\n";
}


#$nonce= 1;
sub dump {
  return;
#  &printref_reset;
  foreach $rs (@_) {
    $rsname= $rs->name;
    $added{$rsname}=0 unless defined($added{$rsname});
    if ($rs->{'Reports_added'} == $added{$rsname}) {
 #     print "(no changes in graphs)\n";
    } else {
      print "** ",$rs->name," **\n";
      $added{$rsname}= $rs->{'Reports_added'};
      print "reports added: ",$rs->{'Reports_added'},"\n";
      foreach $graph ($rs->graphs) {
	$dottext= $graph->dot_text;
	if ($id= $graph{$rsname}{$dottext}) {
	  print "Graph # $id\n";
	} else {
	  &printref($graph);
	  #print "$dottext";
	  #	$graph{$rsname}{$dottext}= $nonce++;
	}
	print "\n";
      }
#    }
#     foreach $node (sort keys %{$rs->{'Inst_gid'}}) {
#       foreach $inst (sort keys %{$rs->{'Inst_gid'}{$node}}) {
# 	print "Inst_gid{$node}{$inst}= ",$rs->{'Inst_gid'}{$node}{$inst},"\n";
#       }
#     }
     foreach $gid (keys %{$rs->{'Gid_ref'}}) {
        print "Gid_ref{$gid}= ",$rs->{'Gid_ref'}{$gid},"\n";
      }
#      foreach $gid (keys %{$rs->{'Gid_cnt'}}) {
#        print "Gid_cnt{$gid}= ",$rs->{'Gid_cnt'}{$gid},"\n";
#      }
}    #&printref($rs);
#    print "\n*****\n";
  }
  #&printref_reset;
}


