#!/pkg/bin/perl -w

# select a size of graph G = (V,E)
# by selecting the number of node nV and the number of edges nE
#
# Christopher Wee 9 July 1996 wee@cs.ucdavis.edu

srand;
$nV = rand 15 + 5;
$nE = rand ($nV * $nV);

$i = 'v001';
@V = map ($i++, 1 .. $nV);	# create vertices

# create edges
foreach $srcVertex (@V) {
  foreach $dstVertex (@V) {
    $E{$srcVertex,$dstVertex} = '1' if rand ($nV * $nV) < $nE;
  }
}

# dump edge matrix
sub ascii {
  foreach $srcVertex (@V) {
    print "  $srcVertex  :";
    foreach $dstVertex (@V) {
      print $E{$srcVertex,$dstVertex} ? '1' : ' ';
    }
  print "\n";
  }
}

# dump edges in "dot" format
print "digraph G {\n";
foreach $srcVertex (@V) {
  foreach $dstVertex (@V) {
    print "  $srcVertex  -> $dstVertex;\n" if $E{$srcVertex,$dstVertex};
  }
  print "\n";
}

print "}\n";

1;
