#!/pkg/bin/perl -w -I../common

# $Id: t.pl,v 1.2 1997/02/01 20:03:46 hoagland Exp $

sub warn {warn @_;}
sub die {die @_;}

print "Start testing Ruleset.pm:\n";
use Ruleset;

#$rs = `./ruleset.gen.pl`;
$rs = `cat easy.rs`;
($name) = $rs =~ /ruleset\s(\S+);/;
print "ruleset $name:\n",$rs;
$r = Ruleset->new_rules($name,$rs);

@rulesets = Ruleset->names;
if (@rulesets != 1 && pop @rulesets != $name) {
   print "test failed. Supposed to have only 1 ruleset named $name in registry.\n";
}
print "deleting ruleset $name from registry.\n";
Ruleset->remove($name);
undef $r;
undef $rs;

exit;


print "Start testing Graph.pm:\n";
use Graph;

#-----------------------------------------------

$name = 'g_01';
$text ='digraph G { a -> b [id=telnet ]}';
print "creating a graph $name w/ $text.\n";
$g = Graph->new($name, $text);
$g->clear_graph;
print "deleting graph $name.\n";
undef $g;


#-----------------------------------------------
$name++;
$text ='digraph G { }';
print "creating a graph $name $text.\n";
print "+++ I think this is broken +++\n";
$g = Graph->new($name, $text);
$g->clear_graph;
print "deleting graph $name.\n";
undef $g;

#-----------------------------------------------

#$name++;
#$text =`./graph.generator.pl`;
#print "creating a graph $name w/ $text.\n";
#$g = Graph->new($name, $text);
#print "deleting graph $name.\n";
#undef $g;

foreach $i (1, 10, 100, 400 ) {
  $name++;
  $text =`./graph.generator.pl size=$i`;
  print "creating a $i node graph -- $name.\n";
  $g = Graph->new($name, $text);
  $g->clear_graph;
  print "deleting graph $name.\n";
  undef $g;
}
print "Finished testing Graph.pm:\n";

1;
