# $Id: noftp.rs,v 1.2 1997/02/01 19:26:50 hoagland Exp $

ruleset noftp;

buffer 0;

timeout 300;

macros {
}

attribute declarations {
server scalar;
name scalar;
}

node precondition 0;

edge precondition new.edge.dport == 21 || new.edge.sport == 20;

########

report global rules {
}

report node rules {
res.node.name= new.node.name;
}

report edge rules {
res.edge.dport= new.edge.dport;
res.edge.sport= new.edge.sport;
res.global.server= cond(new.edge.dport == 21,new.dest.name,new.source.name);
res.edge.count= 1;
res.global.count= 1;
res.global.datareturned= new.edge.sport == 20;
}

########

global rules {
res.global.count= new.global.count+cur.global.count;
res.global.datareturned= new.global.datareturned || cur.global.datareturned;
res.global.server= new.global.server;
}

node rules {
res.node.combine = new.global.server eq cur.global.server;
}

edge rules {
res.edge.combine = new.global.server eq cur.global.server;
res.edge.count= new.edge.count+cur.edge.count;
res.edge.dport= new.edge.dport;
res.edge.sport= new.edge.sport;
}

######

assessments {
res.global.datareturned && report_threshold(res.global.count,1,3,min(res.global.gids)) ==> report_graph(2,"ftp server found on "::global.server);
}
