# $Id: simu_worm.rs,v 1.4 1997/02/01 19:26:22 hoagland Exp $

ruleset simu_worm;
buffer 0;
timeout 99000;

macros {
T=200;
}

attribute declarations {
edges set;
end scalar;
time scalar;
simu set;
}

node precondition defined(new.node.edges);

edge precondition 1;

report global rules {
}

report node rules {
res.global.edges = cond(defined(new.node.edges),{new.node.edges},{});
}

report edge rules {
res.global.edges = {new.edge.id,res.global.edges};
res.source.end = "source";
res.dest.end = "dest";
res.source.time = new.edge.time;
res.dest.time = new.edge.time;
res.edge.time = new.edge.time;
res.edge.simu = [new.edge.simu];
}

global rules {
res.global.edges = {new.global.edges,cur.global.edges};
}

node rules {
# combine if both are not a destination
res.node.combine = (!defined(new.node.time) || abs(cur.node.time - new.node.time) < T) && (!defined(new.node.end) || new.node.end ne "dest" || cur.node.end ne "dest");
# a combined node is a source, unless it is the destination end of combined edges
res.node.end = cond(new.node.end,cond(new.node.end ne "dest" || cur.node.end ne "dest","source","dest"),cur.node.end);
res.node.time = max({new.node.time,cur.node.time});
}

edge rules {
 # maintain a simple graph
res.edge.combine = abs(cur.edge.time - new.edge.time) < T;
res.edge.time = max({new.edge.time,cur.edge.time});
res.edge.simu = [cur.edge.simu,new.edge.simu];
}

assessments {
#report_threshold(res.global.nnodes+res.global.nedges,1,1,"simu_worm") ==> report_graph(1,"worm detected");
1 ==> report_graph(1,"worm detected");
}
