# $Id: sweep2.rs,v 1.2 1997/02/04 22:23:54 grids Exp $

ruleset sweep2;
buffer 0;
timeout 300;

macros {
}

attribute declarations {
end scalar;
name scalar;
root scalar;
}

node precondition 0;

edge precondition defined(new.edge.ctype) && new.edge.ctype eq "rsh";

report global rules {
}

report node rules {
res.global.root = new.node.name;
}

report edge rules {
res.global.root = new.source.name;
res.source.time = new.edge.time;
res.dest.time = new.edge.time;
res.edge.time = new.edge.time;
res.edge.rsh_command = new.edge.rsh_command;
res.edge.color= cond(new.edge.rsh_command =~ /ls$/,"green",new.edge.rsh_command =~ /date$/,"brown",new.edge.rsh_command =~ /passwd/,"red","black");

}

global rules {
res.global.root = cur.global.root;
}

node rules {
res.node.combine = new.global.root eq cur.global.root;
res.node.time = max({new.node.time,cur.node.time});
}

edge rules {
res.edge.combine = 0;
res.edge.time = max({new.edge.time,cur.edge.time});
res.edge.color= new.edge.color;
}

assessments {
report_threshold(res.global.nnodes,4,2,min(res.global.gids)) ==> report_graph(1,"sweep detected");
}

