# $Id: sweep_bof.rs,v 1.1 1997/02/05 09:31:58 grids Exp $

ruleset sweep_bof;
buffer 0;
timeout 300;

macros {
NFS_THRESH=8;
NFS_METRIC=res.global.nedges;
UNK_THRESH=6;
UNK_METRIC=res.global.nnodes;
OTHER_THRESH=4;
OTHER_METRIC=res.global.nnodes;
alert_text=res.global.ctype::" sweep from "::res.global.root::" (n:"::res.global.nnodes::",e:"::res.global.nedges::")";
}

attribute declarations {
ctype scalar;
end scalar;
id scalar;
name scalar;
}

node precondition 0;

edge precondition defined(new.edge.ctype);

report global rules {
}

report node rules {
res.global.root = new.node.name;
}

report edge rules {
res.global.root = new.source.name;
res.global.ctype = new.edge.ctype;
res.edge.color= cond(new.edge.ctype eq "nfs","grey",new.edge.ctype eq "rsh","red",new.edge.ctype eq "telnet","brown",new.edge.ctype eq "www","blue","black");
res.edge.id = new.edge.id;
}

global rules {
res.global.root = new.global.root;
res.global.ctype = new.global.ctype;
}

node rules {
res.node.combine = new.global.root eq cur.global.root && new.global.ctype eq cur.global.ctype;
}

edge rules {
#res.edge.combine = 0;
res.edge.combine = new.global.root eq cur.global.root && new.global.ctype eq cur.global.ctype;
res.edge.ctype= cur.edge.ctype;
res.edge.color= cur.edge.color;
}

assessments {
res.global.ctype eq "nfs" && report_threshold(NFS_METRIC,NFS_THRESH,round(NFS_THRESH*0.4),min(res.global.gids)) ==> report_graph(cond(NFS_METRIC < NFS_THRESH*2,1,2),alert_text);
res.global.ctype ne "unknown" && report_threshold(UNK_METRIC,UNK_THRESH,round(UNK_THRESH*0.4),min(res.global.gids)) ==> report_graph(cond(UNK_METRIC < UNK_THRESH*2,1,2),alert_text);
res.global.ctype ne "nfs" && res.global.ctype ne "unknown" && report_threshold(OTHER_METRIC,OTHER_THRESH,round(OTHER_THRESH*0.4),min(res.global.gids)) ==> report_graph(cond(OTHER_METRIC < OTHER_THRESH*2,1,2),alert_text);
}


