ruleset worm_bof;
buffer 0;
timeout 1000;

macros {
T=45;
}

attribute declarations {
ctype scalar;
end scalar;
id scalar;
name scalar;
time scalar;
}

node precondition 0;

edge precondition defined(new.edge.ctype) && defined(new.edge.dport);

report global rules {
}

report node rules {
}

report edge rules {
res.global.dport = new.edge.dport;
res.global.prot = new.edge.prot;
res.global.ctype = new.edge.ctype;
res.edge.id = new.edge.id;
res.source.end = "source";
res.dest.end = "dest";
res.source.time = new.edge.time;
res.dest.time = new.edge.time;
res.edge.time = new.edge.time;
}

global rules {
res.global.dport = new.global.dport;
res.global.prot = new.global.prot;
res.global.ctype = new.global.ctype;
}

node rules {
res.node.combine = ((!defined(new.node.time) || abs(cur.node.time - new.node.time) < T)) && (new.node.end ne "dest" || cur.node.end ne "dest") && (new.global.dport eq cur.global.dport) && (new.global.prot eq cur.global.prot);
res.node.end = cond(new.node.end ne "dest" || cur.node.end ne "dest","source","dest");
res.node.time = max({new.node.time,cur.node.time});
}

edge rules {
res.edge.combine = (abs(cur.edge.time - new.edge.time) < T) && (new.global.dport eq cur.global.dport) && (new.global.prot eq cur.global.prot);
res.edge.time = max({new.edge.time,cur.edge.time});
}


assessments {
report_threshold(nnodes,3,2,min(gids)::prot::dport) ==> report_graph(3,"worm_bof ("::prot::":"::dport::") #"::min(gids));
}

