# $Id: worm_bof.multi_level.rs,v 1.1 1997/03/20 18:08:16 hoagland Exp $

ruleset worm_bof;
buffer 0;
timeout 1000;

macros {
}

attribute declarations {
ctype scalar;
depth scalar;
id scalar;
name scalar;
}

node precondition 0;

edge precondition defined(new.edge.ctype) && defined(new.edge.dport);

report global rules {
res.global.depth=0;
}

report node rules {
res.node.depth=0;
}

report edge rules {
res.global.dport = new.edge.dport;
res.global.prot = new.edge.prot;
res.global.ctype = new.edge.ctype;
res.edge.id = new.edge.id;
res.source.depth = 0;
res.dest.depth = 1;
res.edge.depth = 1;
res.global.depth=1;
}

global rules {
res.global.dport = new.global.dport;
res.global.prot = new.global.prot;
res.global.ctype = new.global.ctype;
res.global.depth= max({new.global.depth,cur.global.depth});
}

node rules {
# don't combine (on the basis of this node) if either are dests or the protocols don't match
res.node.combine = !(new.node.depth == new.global.depth || cur.node.dept == cur.global.depth) && (new.global.dport eq cur.global.dport) && (new.global.prot eq cur.global.prot);
res.node.depth = max({new.node.depth,cur.node.depth});
res.node.delta = cur.node.depth - new.node.depth;
}

edge rules {
# always combine like edges if the protocols match
res.edge.combine = (new.global.dport eq cur.global.dport) && (new.global.prot eq cur.global.prot);
}

assessments {
report_threshold(nnodes,3,2,min(gids)::prot::dport) ==> report_graph(3,"worm_bof ("::prot::":"::dport::") #"::min(gids));
}

