# $Id: worm_detector2.rs,v 1.2 1997/02/01 19:10:52 hoagland Exp $

ruleset worm_detector2;

buffer 10;

timeout 30;

macros {
L=30;
}

attribute declarations {
time scalar;
alert scalar;
}

node precondition defined(new.node.time) && 
                     defined(new.node.alert);


edge precondition defined(new.edge.time);

########

report global rules {
res.global.alerts = {};
res.global.time = 0;
}

report node rules {
res.global.alerts = {res.global.alerts,new.node.alert};
res.node.alerts = {new.node.alert};
res.global.time = max({res.global.time,new.node.time});
res.node.time = new.node.time;
}

report edge rules {
res.global.alerts = {res.global.alerts,new.edge.alert};
res.edge.alerts = {res.edge.alerts,new.edge.alert};
res.global.time = max({res.global.time,new.edge.time,new.source.time,new.dest.time});
res.edge.time = max({new.edge.time,new.source.time,new.dest.time});
}

########

global rules {
res.global.alerts = {new.global.alerts, 
                      cur.global.alerts};
}

node rules {
res.node.combine = !empty({new.node.alerts,cur.node.alerts}) && 
     abs(cur.node.time - new.node.time) < L;
res.node.alerts = {cur.node.alerts,
			new.node.alerts};
res.node.time = max({cur.node.time,new.node.time});
}

edge rules {
res.edge.combine = abs(cur.edge.time 
                         - new.edge.time) < L;
res.edge.alerts = {cur.edge.alerts,
		    new.edge.alerts};
res.edge.time =
        max({cur.edge.time, new.edge.time});
}

######

assessments {
!empty(global.alerts) ==>  alert(2,"alert!");
global.nnodes > 7 ==> alert(1,"> 7 nodes in graph");
global.nedges > 12 ==> report_graph(3,"from worm_detector");
global.nnodes > 3 ==> report_graph(1,global.nnodes::" nodes in graph");
global.nedges > 5 ==> report_graph(1,"");
}
