# $Id: worm_detector_sd.rs,v 1.2 1997/02/01 19:11:27 hoagland Exp $

ruleset worm_detector_sd;
buffer 0;
timeout 1000;

macros {
}

attribute declarations {
ctype scalar;
dport scalar;
end scalar;
id scalar;
local_login_name scalar;
remote_login_name scalar;
rsh_command scalar;
sport scalar;
stage scalar;
status scalar;
time scalar;
}

node precondition 0;

edge precondition defined(new.edge.ctype) && new.edge.ctype eq "rsh";

report global rules {
res.global.users = {};
res.global.commands = {};
res.global.hosts = {};
}

report node rules {
res.global.hosts = {res.global.hosts, new.node.name};
res.node.name = new.node.name;
}

report edge rules {
res.global.users = {res.global.users, new.edge.local_login_name, new.edge.remote_login_name};
res.global.commands = {res.global.commands, new.edge.rsh_command};
res.edge.dport = new.edge.dport;
res.edge.id = new.edge.id;
res.edge.sport = new.edge.sport;
res.edge.stage = new.edge.stage;
res.edge.status = new.edge.status;
new.source.end = "source";
new.dest.end = "dest";
new.source.time = new.edge.time;
new.dest.time = new.edge.time;
}

global rules {
res.global.hosts = {new.global.hosts, cur.global.hosts};
res.global.commands = {new.global.commands, cur.global.commands};
res.global.users = {new.global.users, cur.global.users};
}

node rules {
res.node.combine = (new.node.end == "source" && cur.node.end == "dest" && new.node.time > cur.node.time + 5) || (new.node.end == "dest" && cur.node.end == "source" && cur.node.time > new.node.time + 5);
res.node.time = max(new.node.time, cur.node.time);
}

edge rules {
res.edge.combine = 0;
}

assessments {
res.global.nnodes == 4 ==> report_graph(2,"Small sweep");
res.global.nnodes == 5 ==> report_graph(3,"Medium sweep");
res.global.nnodes == 6 ==> report_graph(4,"Large sweep");
}
