#!/pkg/bin/perl -w

use Comm;
use control_vars;
use Clog;
use Fcntl;

$| = 1;    # don't delay by buffering STDOUT

# get incoming args from module_controller parent:
# ($path_prefix, $init_file, $dept_ID, $aggregator_host_port)= @ARGV;

$vars = new control_vars ();

# Important to load "standard" control vars:
$vars->{'module'} = "sniffer";
$vars->{'version'} = "v.bin";        # this one is usually ignored.

$vars->add_straight('parent_aggregator');
$vars->{'parent_aggregator'} = 'sierra.cs.ucdavis.edu:5500'
	unless $vars->{'parent_aggregator'}; # might be set by 
					     # new control_vars()
($engine_host, $engine_port) =
	$vars->{'parent_aggregator'} =~ /^([^:]*):(\d+)$/;

# ($status, $tcp, $udp) =
&Comm::init (undef, undef);


         ### CAUTION:  SYSTEM DEPENDENCY::
$hostname = `/usr/bin/uname -n`;  chomp $hostname;

$my_log = new Clog ($vars->{'module'}, $vars->{'department'},
                    "snif.$hostname.$vars->{'department'}"); # local error file
$my_log->{'central_log'} = 0;
$my_log->{'prefix'} = " (PID$$) ";


$vars->add_indexed('verbose');
       # clog->warn about all incoming reports:
$vars->{'verbose'}{'incoming'} = 0 unless exists $vars->{'verbose'}{'incoming'};
       # clog->warn about all outgoing reports:
$vars->{'verbose'}{'outgoing'} = 0 unless exists $vars->{'verbose'}{'outgoing'};
       # clog->warn about all changes to endpoint filter:
$vars->{'verbose'}{'endpoints'} = 1 unless
        exists $vars->{'verbose'}{'endpoints'};
       # clog->warn about deleting udp sessions:
$vars->{'verbose'}{'udp_sessions'} = 1 unless
        exists $vars->{'verbose'}{'udp_sessions'};


#RC 7/11/97: to manage unacceptable growth of tcpdump:
$SIG{ALRM} = 'catch_alarm';   # test if current tcpdump exceeds memsize limit.
$vars->add_straight('tcpdump_alarm_frequency');    # in minutes
$vars->add_straight('tcpdump_max_memory_mbytes');  # in Mbytes
$vars->add_straight('tcpdump_max_memory_percent'); # in %


$vars->{'tcpdump_alarm_frequency'} = 10;         # use 1 minute for testing
$vars->{'tcpdump_max_memory_mbytes'} = 10        # use 4 Mbyte for testing
   unless $vars->{'tcpdump_max_memory_mbytes'};
$vars->{'tcpdump_max_memory_percent'} = 5.0      # use 1.0% for testing
   unless $vars->{'tcpdump_max_memory_percent'};

# { ##################### FILTERING CRITERIA ##########################

$vars->add_indexed('excluded_username');    # RC 7/11/97: extra privacy
# $vars->{'excluded_username'}{'crawford'} = 1;         # opt out ;-)

# the form of the connections that are wanted to be printed out
# 'source IP address; destinaton IP address; protocol type'
# currently the following protocol types are supported: telnet,
# nfs, and rsh

# endpoint_filter is a list of 3-tuples 
$vars->add_straight("add_endpoint_filter");
$vars->add_straight("delete_endpoint_filter");
$vars->add_straight("current_endpoint_filter");

unless ($vars->{"current_endpoint_filter"}) {
  # these tmp defaults should not overwrite any initialization values
  $wanted_connection{'* * *'} = 1;	# get all the connections
  $vars->{"current_endpoint_filter"} =
       &print_endpoints (\%wanted_connection, 'canonical form')
  }
  # at startup, we ignore command to add_endpoint_filter


# unwanted_connection / neg_endpoint_filter is a list of 3-tuples
$vars->add_straight("current_neg_endpoint_filter");
$vars->add_straight("add_unwanted_connection");
$vars->add_straight("delete_unwanted_connection");

unless ($vars->{"current_neg_endpoint_filter"}) {
  # these tmp defaults should not overwrite any initialization values
  # $unwanted_connection{'rainier k6 telnet'} = 1;
  # $unwanted_connection{'k6 rainier telnet'} = 1;
  $vars->{"current_neg_endpoint_filter"} =
       &print_endpoints (\%unwanted_connection, 'canonical form');
  }
  # at startup, we ignore command to add_unwanted_connection

&print_endpoints (\%wanted_connection, '%wanted_connection');  #DBG
&print_endpoints (\%unwanted_connection, '%unwanted_connection');  #DBG



$vars->add_straight('set_time_windows');    # a list of 2-tuples
$wanted_duration{'0:0 23:59'} = 1;
$vars->{'set_time_windows'} = "00:00 23:59";


# the maximum size of a udp session, in seconds
$vars->add_straight('set_session_window');
$vars->{'set_session_window'} = 5;
$session_window = 5;

# the minimum space between two udp sessions, in seconds
$vars->add_straight('set_session_gap');
$vars->{'set_session_gap'} = 2;
$session_gap = 2;

# } ##################### FILTERING CRITERIA ##########################


$vars->add_straight("shutdown");
$vars->{"shutdown"} = "";      # watch out -- value of string "false" is True!

$vars->add_straight("startup");
$vars->{"startup"} = "";


$vars->update();




# the duration between two checkpoints 
$checkpoint_duration = 5;

# the time that a check point of the upd_sessions is done
$last_checkpoint = time();

$sessions = {}; 

&init_ps_for_os();
&restart_tcpdump(0);

while ($report = <TCPDUMP> || "NO REPORT") {

    ###############################
  { # CHECK THE CONTROL VARIABLES #
    ###############################
    $command->{'command'} = "";
    my $block = 0;  # should we block waiting for a command?
    $command = $vars->get_command($block);
    if (%$command  &&  $command->{'command'} =~ /GET/i) {
        $vars->update();            # write current state to our status file
        $vars->complete_command();  # unlink the command file
    } elsif (%$command  &&  $command->{'command'} =~ /SET/i) {

	#######################################
        # check the shutdown control variable #
	#######################################
        if (exists($command->{"shutdown"}) && $command->{"shutdown"}) {
            print "shutdown\n";
            # set the command variable whose value will be copied
            # into var at the simple assignment below
            # for testing purpose only
	    kill 'SIGHUP', $pid;
            close(TCPDUMP);      # do this after kill; else may wait() forever
            $my_log->separator();
            $my_log->warn ("tcpdump \$pid $pid shutdown.\n");
            $command->{"shutdown"} = "shutdown_okay";
        }


	######################################
        # check the startup control variable #
	######################################
        if (exists($command->{"startup"}) && $command->{"startup"}) {
            print "startup\n";
            &restart_tcpdump ($pid);
        }


	#########################################################
        # check the tcpdump alarm and memsize control variables #
	#########################################################

        # if (exists($command->{'tcpdump_max_memory_mbytes'})) { }
        # if (exists($command->{'tcpdump_max_memory_percent'})) { }

        # Do nothing here; &do_set() below will copy $command into $vars,
        # and those updated $vars will be used next alarm cycle.

        if (exists($command->{'tcpdump_alarm_frequency'})) {
            alarm $command->{'tcpdump_alarm_frequency'} * 60;
            # Convert minutes to seconds.
            # This cancels previous alarm.  Since we have at least 59 seconds
            # assuming incoming value was sane, we can be confident that
            # any incoming tcpdump_max_memory_ values will be updated in time.
            }


	################################################
        # check the excluded_username control variable #
	################################################

        if (exists $command->{'excluded_username'}) {
          # RC 7/11/97: extra privacy
          my @tuples = split("\n", $command->{'excluded_username'});  
          my ($username, $exclude_include);
          foreach $tuple (@tuples) {
            ($username, $exclude_include) = split (' ', $tuple);
            $vars->{'excluded_username'}{$username} = $exclude_include;
            # a nonzero value for $exclude_include means exclude them.
            }
          delete $command->{'excluded_username'};
          # Else &do_set() below would try to copy $command into $vars.
          # Although they share common semantics, their syntax differs.
        }


	################################################
        # check the parent aggregator control variable #
	################################################
        if (exists($command->{'parent_aggregator'}) &&
                   $command->{'parent_aggregator'}) {
            # set the command variable whose value will be copied
            # into var at the simple assignment below

            if ($command->{'parent_aggregator'} =~ /^([^:]*):(\d+)$/) {
              ($engine_host, $engine_port) = ($1, $2);
              $my_log->warn ('SET to new parent_aggregator: <'
                  . "$engine_host:$engine_port>\n");
              }
            else {
              $my_log->warn
                 ('I will not obey bad command to SET parent_aggregator: <'
                 . $command->{'parent_aggregator'} . '>.');
	      delete $command->{'parent_aggregator'};
              }
        }


	#############################################
        # check the session window control variable #
	#############################################
        if (exists($command->{"set_session_window"})) {
            print "set session_window\n";
	    $session_window = $command->{"set_session_window"};
        }


	##########################################
        # check the session gap control variable #
	##########################################
        if (exists($command->{"set_session_gap"})) {
            print "set session_gap\n";
	    $session_gap = $command->{"set_session_gap"};
        }


	###############################################
    	# check the endpoint_filter control variables # 
	###############################################
    	$endpoints_changed = 0;

        if (exists($command->{"current_endpoint_filter"})) {
          %wanted_connection = {};
          &add_endpoints ($command->{"current_endpoint_filter"},
                          'current_endpoint_filter', \%wanted_connection);
        }
        if (exists($command->{"add_endpoint_filter"})) {
          &add_endpoints ($command->{"add_endpoint_filter"},
                          'add_endpoint_filter', \%wanted_connection);
          undef $command->{"add_endpoint_filter"};  # optional
        }

    	if (exists($command->{"delete_endpoint_filter"})) {
            my ($source, $dest, $prot);
            # endpoint filter tuples are on separate lines in same string:
            my @tuples = split("\n", $command->{"delete_endpoint_filter"});  
            while (@tuples) {
            	($source, $dest, $prot) =
                    shift(@tuples) =~ /^\s*(\S+)\s+(\S+)\s+(\S+)\s*$/;
                unless ($source && $dest && $prot) {
                  $my_log->warn ("delete_endpoint_filter is not all 3-tuples!");
            	  next;
            	}
                delete $wanted_connection{"$source $dest $prot"};
            }
            $endpoints_changed = 1;
            undef $command->{"delete_endpoint_filter"};  # optional
    	}


	###################################################
    	# check the unwanted connection control variables # 
	###################################################

        if (exists($command->{"current_neg_endpoint_filter"})) {
          %unwanted_connection = {};
          &add_endpoints ($command->{"current_neg_endpoint_filter"},
                          'current_neg_endpoint_filter', \%unwanted_connection);
        }
    	if (exists($command->{"add_unwanted_connection"})) {
          &add_endpoints ($command->{"add_unwanted_connection"},
                          'add_unwanted_connection', \%unwanted_connection);
          undef $command->{"add_unwanted_connection"};  # optional
    	}

    	if (exists($command->{"delete_unwanted_connection"})) {
            my ($source, $dest, $prot);
            # endpoint filter tuples are on separate lines in same string:
            my @tuples = split("\n", $command->{"delete_unwanted_connection"});
            while (@tuples) {
            	($source, $dest, $prot) =
                    shift(@tuples) =~ /^\s*(\S+)\s+(\S+)\s+(\S+)\s*$/;
                unless ($source && $dest && $prot) {
                  $my_log->warn
                     ("delete_unwanted_connection is not all 3-tuples!\n");
            	  next;
            	}
                delete $unwanted_connection{"$source $dest $prot"};
            }
            $endpoints_changed = 1;
            undef $command->{"delete_unwanted_connection"};  # optional
    	}

        # summarize *all* endpoint changes in one single control_var:
        if ($endpoints_changed) {
            &print_endpoints (\%wanted_connection, '%wanted_connection')
               if $vars->{'verbose'}{'endpoints'};
            $command->{"current_endpoint_filter"} =
                    &print_endpoints (\%wanted_connection, 'canonical form');

            &print_endpoints (\%unwanted_connection, '%unwanted_connection')
               if $vars->{'verbose'}{'endpoints'};
            $command->{"current_neg_endpoint_filter"} =
                    &print_endpoints (\%unwanted_connection, 'canonical form');
        }
	#  IMPORTANT: You must do the above for $vars instead of $command
        #             if you delete the call to &do_set below!


	########################################
        # check time windows control variables #
	########################################
    	if (exists($command->{"set_time_windows"})) {
	    my ($start_time, $stop_time);
            my @times = split ("\n", $command->{"set_time_windows"});
            while (@times) {
		($start_time, $stop_time) = 
		    shift (@times) =~ /^\s*(\d+:\d+)\s+(\d+:\d+)\s*$/; 
 		unless ($start_time && $stop_time) {
                  $my_log->warn ("set_time_windows is not all 2-tuples!\n");
	   	}
		$wanted_duration{'$start_time $stop_time'} = 1;
            	print "new start time is $start_time; ";
            	print "new stop time is $stop_time.\n";
            }
        }

        # simple assignment to SET control vars:
        &control_vars::do_set (*command, *vars);

        $vars->update();            # write changes to our status file
        $vars->complete_command();  # unlink the command file
    }
    ###############################
  } # CHECK THE CONTROL VARIABLES #
    ###############################


    # check the udp sessons 
    if ((time() - $last_checkpoint) > $checkpoint_duration) {
	# check the udp hash
	foreach $key (keys %sessions) {
	    my ($start, $last, $count, $old_report) = 
		$sessions{$key} =~ /^(\d+) (\d+) (\d+) (.*)$/;
 	    if ((time() - $start) > $session_window) {
		$old_report =~ s/, id\=\"/, group_size=$count, id\=\"/;
		$my_log->warn ("Deleting old UDP session: <$old_report>\n")
		  if $vars->{'verbose'}{'udp_sessions'};
		delete $sessions{$key}; 
	    }
	}
    }


    ##########################
    # PROCESSING THE REPORTS #
    ##########################

    if ($report eq "NO REPORT") {
        # don't hog cpu; do a short sleep to allow sniffer to run:
        select (undef, undef, undef, 0.2);
 	next;
    }


                                   # balance brace below {
if (($report =~ /^\s*digraph sniffer/) && !($report =~ /\}\s*/)) {
    $my_log->warn ("**** missing a part of the report:\n<$report>\n");
    next;
}

    $my_log->warn ("Incoming Report ==> <$report>\n\n")
       if $vars->{'verbose'}{'incoming'};

    if (($report =~ /^digraph sniffer/)) {
	# extract the source/dest ip_address and the protocol from 
	# the current report
	($sIP, $dIP, $rest) = 
	    $report =~ /^digraph sniffer { "(\S+)" -> "(\S+)"(.*)/; 
	                               # } to balance the open curly 

	unless ($sIP && $dIP && $rest) { next; }

	$conn_type = $sport = $dport = $stage = $ts_hour = $ts_minute = "";

	($conn_type) = $rest =~ /ctype="(\S+)".*/;
	($sport) = $rest =~ /, sport=(\d+).*/;
	($dport) = $rest =~ /, dport=(\d+).*/;
	($stage) = $rest =~ /, stage="(\w+)".*/;
	($ts_hour, $ts_minute) = $rest =~ /, timestamp="(\d+):(\d+).*/;

	unless ($conn_type && $sport && $dport && $stage && 
		$ts_hour && $ts_minute && 
		( ($dport != $engine_port) ||
		($dIP ne $engine_host) ) ) { 
	    next; 
	}

	# check against the wanted connection list 
	undef $matched;  
	@wanted_keys = keys %wanted_connection;
	while ($#wanted_keys >= 0) {
	    ($wanted_source, $wanted_dest, $wanted_prot) = 
	        pop(@wanted_keys) =~ /^\s*(\S+)\s+(\S+)\s+(\S+)\s*$/;

	    if (($wanted_source eq "*" || $wanted_source eq $sIP) && 
		($wanted_dest eq "*" || $wanted_dest eq $dIP) && 
		($wanted_prot eq "*" || $wanted_prot eq $conn_type)) {
		$matched = "TRUE";
		last;
	    }
	}

	# check against the wanted duration list
	if ($matched) {
	    undef $matched;
	    @wanted_keys = keys %wanted_duration;
	    while ($#wanted_keys >= 0) {
	        my ($wanted_start_hour, $wanted_start_minute, 
		    $wanted_stop_hour, $wanted_stop_minute) = 
	            pop(@wanted_keys) =~ /^\s*(\d+):(\d+)\s+(\d+):(\d+)\s*$/;

  	        my $wanted_start_min = 60 * $wanted_start_hour + 
				       $wanted_start_minute;
  	        my $wanted_stop_min = 60 * $wanted_stop_hour + 
				      $wanted_stop_minute;
	        my $ts_min = 60 * $ts_hour + $ts_minute;

	        $stop_to_cur = $wanted_stop_min - $ts_min;
	        if ($stop_to_cur < 0) {
	    	    $stop_to_cur = $stop_to_cur + 1440;
	        }
	        $stop_to_start = $wanted_stop_min - $wanted_start_min;
	        if ($stop_to_start < 0) {
	    	    $stop_to_start = $stop_to_start + 1440;
	        }
	        if ($stop_to_cur <= $stop_to_start) {
		    $matched = "TRUE";
	            last;
	        }
	    }
	}

	# check udp sessions 
	if (($matched) && ($conn_type eq "nfs") && 
	    (($stage eq "READ") || ($stage eq "WRITE"))) { 
	    undef $matched;
	    my $key = $sIP.$dIP.$sport.$dport.$stage;
	    my $cur_time = time();
	    if ($sessions{$key}) {
	        my ($start, $last, $count, $old_report) = 
		    $sessions{$key} =~ /^(\d+) (\d+) (\d+) (.*)$/;
		if ($start && $last && $count && 
		    ((($cur_time - $last) > $session_gap) || 
		    (($cur_time - $start) > $session_window))) { 
		    # creat new session
		    $sessions{$key} = "$cur_time $cur_time 1 $report";
		    # report the old session
		    $matched = "TRUE";  # or try to print a summary report
		    $old_report =~ s/, id\=\"/, group_size=$count, id\=\"/;
		    $report = $old_report;  # print old report 
		} else {
		    # add to current session
		    $count++;
		    $sessions{$key} = "$start $cur_time $count $old_report";
		}
	    } else {
		# add a new entry in udp sessions
		$sessions{$key} = "$cur_time $cur_time 1 $report";
	    }
	    $last_checkpoint = $cur_time;
	}

	# check against the unwanted connection list 
	if ($matched) {
	    undef $match_unwanted;  
	    my @unwanted_keys = keys %unwanted_connection;
	    while ($#unwanted_keys >= 0) {
	        my ($unwanted_source, $unwanted_dest, $unwanted_prot) = 
	            pop(@unwanted_keys) =~ /^\s*(\S+)\s+(\S+)\s+(\S+)\s*$/;

	        if (($unwanted_source eq "*" || 
		     $unwanted_source eq $sIP) && 
		    ($unwanted_dest eq "*" || $unwanted_dest eq $dIP) && 
		    ($unwanted_prot eq "*" || $unwanted_prot eq $conn_type)) {
		    $match_unwanted = "TRUE";
		    last;
	        }
	    }
	}

	if ($matched  &&  !$match_unwanted  &&
            !&excluded_user ($conn_type, \$report) ) {

          $my_log->warn ("Outgoing Report to [$engine_host:$engine_port] ==> "
                . "\n<$report>\n\n") if $vars->{'verbose'}{'outgoing'};

	  &Comm::tcp_send ( $engine_host, $engine_port, 'r', $report);
	}

    } 

}


    ##########################################################################
    #######################       SUBROUTINES       ##########################
    ##########################################################################


sub print_endpoints {
  my $result = '';
  if ($_[1] eq 'canonical form') {
    foreach $key (keys %{$_[0]}) {
      $result .= "$key\n";
      }
    return $result;
    }

  # else print in more human readable form:
  foreach $key (keys %{$_[0]}) {
    $result .= "              ($key)\n";
    }
  $my_log->warn ("\nThe new $_[1] endpoint filter (source, dest, protocol):\n"
               . "$result\n");
}   ##########################################################################


sub add_endpoints {
  my ($source, $dest, $prot);
  # endpoint filter tuples are on separate lines in same string:
  my @tuples = split("\n", $_[0]);
  while (@tuples) {
    ($source, $dest, $prot) = shift(@tuples) =~ /^\s*(\S+)\s+(\S+)\s+(\S+)\s*$/;
    unless ($source && $dest && $prot) {
      $my_log->warn ("$_[1] is not all 3-tuples!\n");
      next;
      }
    ${$_[2]}{"$source $dest $prot"} = 1;
    # cannot make $_[2] a "my" var with a more descriptive name,
    # because that makes a local *copy* of hash table, and we modify our copy.
  }
  $endpoints_changed = 1;     # set global flag
} ###########################################################################




sub restart_tcpdump {
  my $prefix = '';
  if ($_[0]) {     # then it's a re-start, and we should kill that old $pid
    kill 'SIGHUP', $_[0];
    close(TCPDUMP);      # do this after kill; else may wait() forever
    $my_log->separator();
    $prefix = 're-';
    }

  $pid = open(TCPDUMP, "$TCPDUMPLOC/tcpdump -s 1024 -g -T rpc |")  || 
         $my_log->warn ("Cannot ${prefix}start SNIFFER!");
  # fcntl (TCPDUMP, F_SETFL, O_NDELAY)  ||
  #      $my_log->warn ("Can't make non-blocking\n");

  unless ($_[0]) {     # we are the initial start; must set alarm:
    alarm $vars->{'tcpdump_alarm_frequency'} * 60;  # convert minutes to seconds
    }

  # set the command variable whose value will be copied
  # into var at the simple assignment below
  # for testing purpose only
  if (defined $pid  &&  $pid > 1) {
    $command->{"startup"} = "tcpdump ${prefix}started ok as \$pid $pid";
    $my_log->warn ("tcpdump ${prefix}started ok as \$pid $pid\n");
    }
  else {
    $command->{"startup"} = "${prefix}startup_FAILED at " . `date`;
    $command->{'command'} = "ERROR- ${prefix}startup of tcpdump FAILED";
    $my_log->warn ("ERROR- ${prefix}start of tcpdump FAILED\n");
    }
} ###########################################################################



# Determine ostype, and build a ps command to check our tcpdump child:
sub init_ps_for_os {
$uname = `/usr/bin/uname -a`;
if ($uname =~ /SunOS \S+ 5[\d\.]+ Generic/) {
  $uname = 'solaris';
  $ps_comm = '/bin/ps -o vsz -p ';
  $ps_pattern = '(\d+)';    # VSZ \n %MEM (in kbytes)
  }
elsif ($uname =~ /SunOS/) {
  $uname = 'sunos';
  $ps_comm = '/bin/ps -wv';
  #### This is horrible on krakatoa!  We'll have to use the %MEM column,
  #### because the SZ/SIZE and RSS columns have no bearing on reality,
  #### as displayed by "top".
  # build a legible PS pattern-matcher that humans can maintain/port/upgrade:
  $ps_pattern  = '\d+\s+\S+\s+\S+\s+';         # PID TT STAT
  $ps_pattern .= '\S+\s+\d+\s+\d+\s+';         # TIME SL RE
  $ps_pattern .= '\d+\s+\d+\s+\d+\s+\S+\s+';   # PAGEIN SIZE RSS LIM
  $ps_pattern .= '[\d\.]+\s+([\d\.]+)\s+\S+';  # %CPU %MEM COMMAND
  }
elsif ($uname =~ /ULTRIX/i) {
  $uname = 'ultrix';
  $ps_comm = '/bin/ps -wv';
  # build a legible PS pattern-matcher that humans can maintain/port/upgrade:
  $ps_pattern  = '\d+\s+\S+\s+\S+\s+';         # PID TT STAT
  $ps_pattern .= '\S+\s+\d+\s+\d+\s+';         # TIME SL RE
  $ps_pattern .= '\d+\s+\d+\s+\d+\s+\S+\s+';   # PAGEIN SIZE RSS LIM
  $ps_pattern .= '\d+\s+\d+\s+';               # TSIZ TRS
  $ps_pattern .= '[\d\.]+\s+([\d\.]+)\s+\S+';  # %CPU %MEM COMMAND
  }

} ###########################################################################




sub catch_alarm {         # RC 7/11/97: manages unacceptable growth of tcpdump.

  my ($memsize) = `$ps_comm$pid` =~ /$ps_pattern/;   # this is in % or Mbytes

  # test if current tcpdump exceeds memsize limit:

  if ($uname =~ /solaris/i) {
    $memsize /= 1000;                           # convert kbytes to Mbytes
    if ($memsize >= $vars->{'tcpdump_max_memory_mbytes'}) {
      &restart_tcpdump ($pid);
      $my_log->warn ("(tcpdump memsize of $memsize exceeded limit of"
                   . " $vars->{'tcpdump_max_memory_mbytes'} mbytes)\n");
      }
    else {
      $my_log->warn (`date` . "\t and tcpdump memsize of $memsize"
                   . " is less than $vars->{'tcpdump_max_memory_mbytes'}"
                   . " mbytes\n");
      }
    }
  elsif ($uname =~ /SunOS/i) {
    if ($memsize >= $vars->{'tcpdump_max_memory_percent'}) {
      &restart_tcpdump ($pid);
      $my_log->warn ("(tcpdump memsize of $memsize exceeded limit of"
                   . " $vars->{'tcpdump_max_memory_percent'} percent)\n");
      }
    else {
      $my_log->warn (`date` . "\t and tcpdump memsize of $memsize"
                   . " is less than $vars->{'tcpdump_max_memory_percent'}"
                   . " percent\n");
      }
    }
  elsif ($uname =~ /ULTRIX/i) {
    if ($memsize >= $vars->{'tcpdump_max_memory_percent'}) {
      &restart_tcpdump ($pid);
      $my_log->warn ("(tcpdump memsize of $memsize exceeded limit of"
                   . " $vars->{'tcpdump_max_memory_percent'} percent)\n");
      }
    else {
      $my_log->warn (`date` . "\t and tcpdump memsize of $memsize"
                   . " is less than $vars->{'tcpdump_max_memory_percent'}"
                   . " percent\n");
      }
    }

  # reset alarm:
  alarm $vars->{'tcpdump_alarm_frequency'} * 60;  # convert minutes to seconds
} ###########################################################################





sub excluded_user {
  my ($conn_type, $report) = @_;
  my ($username, $exclude);
  if ($conn_type eq 'telnet') {   # $$report format::
    # stage="AUTH", status="ERR", login_name="\c\r\a\w\f\o\r\d\\10\\13",
    # password="\ \m\y\p\a\s\s\\10\\0\\13\\10",   {not reported by new tcpdump}

    return 0 unless $$report =~ /stage="AUTH", status="(ERR|SUC)"/;
         # Those are only telnet stages that might contain username.

    ($username) = $$report =~ /, login_name="([^"]+)"/;
    $username =~ tr/\\//d;                        # delete backslash chars
    ($username) = $username =~ /^(.*)1013$/;      # prune tailfeathers
    if ( exists $vars->{'excluded_username'}{$username}  &&
                $vars->{'excluded_username'}{$username} ) {
      $$report =~ s/login_name="[^"]+"/login_name="XXX"/;
      # $exclude = 1;
      }
    }
  elsif ($conn_type eq 'rsh') {   # $$report format::
    # local_login_name="crawford", remote_login_name="crawford", rsh_command="x"
    ($username) = $$report =~ /, local_login_name="([^"]+)"/;
    if ( exists $vars->{'excluded_username'}{$username}  &&
                $vars->{'excluded_username'}{$username} ) {
      $$report =~ s/local_login_name="[^"]+"/local_login_name="XXX"/;
      $$report =~ s/remote_login_name="[^"]+"/remote_login_name="XXX"/;
      # $exclude = 1;
      }
    }
  return $exclude;
} ###########################################################################




