#!/pkg/bin/perl -w

# $Id: grids,v 1.42 1997/07/02 05:40:34 crawford Exp $

# This script sets up a simple hierarchy as a sample to begin with.

use Hierarchy_interface;
use Test_script;
use Clog;
use Mod_utility;
use Grdbm;
#-----------------------------------------------------------------------
#
#  Add the new department's configuration manually
#
my @host_list = ( 'k2.cs.ucdavis.edu',
                );
my $dept_name = 'ROOT';
#
#-----------------------------------------------------------------------
$user = "root";
$pass = "enter_now";

local $grids_db = $Hierarchy_interface::grids_db; # Hierarchy configuration

my ($ohs_host,$ohs_port) = split(/:/,$Hierarchy_interface::ohs_location);

$log = new Clog('grids_test','N/A',"grids.test.log"); # Set up our log
$log->{'central_log'} = 0; # No central logging - presently broken.

($ok, $h) 
     = new Hierarchy_interface($user,$pass,'ROOT',$log,'comm','main::FILE');

goto DELETE if $ARGV[0] eq 'delete';
goto DELETE if $ARGV[0] eq 'remove';
goto DELETE if $ARGV[0] eq 'kill';
goto DELETE if $ARGV[0] eq 'destroy';
#
# Added by J.Rowe to add a new dept

unless ( (exists $h->{hierarchy}{$dept_name})  &&
	(ref $h->{hierarchy}{$dept_name} eq 'Department') ) {
    print "No dept $dept_name exists, bail out...\n";
    die;
}

foreach $host ( @host_list ) {
    if ($host ne $dept_sm_host && $host ne $dept_agg_host) {
	unless ( (exists $h->{hierarchy}{$host})  &&
		(ref $h->{hierarchy}{$host} eq 'Host') ) {
	    push( @{$grids_db->{'module_hosts'}}, $host );
	    $grids_db->{'module_ports'}{$host} = 'none';
	    $grids_db->{'host_to_dept'}{$host} = $dept_name;
	    print "Added $host to the grids database\n";
	    print "Adding host $host to the hierarchy under $dept_name\n";
	    $h->add_host($dept_name, $host, $grids_db->{'module_ports'}{$host})
		unless exists $h->{hierarchy}{$host};
	    print "...done\n";
	}
    }
}

$log->warn("done adding new host");

goto OUTPUT;

DELETE:

print "Removing dept $dept_name from the hierarchy under $dept_parent...\n";

($status,$message) = $h->remove_dept ($dept_name);

print "...Killing aggregator on $dept_agg_host...\n";
&slay($dept_agg_host, 'engine|sniffer|netstat|tcpdump');
print "...Killing software manager on $dept_sm_host...\n";
&slay($dept_sm_host, 'sm/sm');

foreach $host (@host_list) {
    print "...Killing module_controller on $host...\n";
    &slay($host, 'module_controller');
}


die ($message) unless $status;
print "...done\n";

$log->warn("Done removing dept $dept_name");

goto OUTPUT;

OUTPUT:

$h->{'hierarchy'}->save("$ENV{'GRIDSPATH'}/log/output_hierarchy",
                            'prettyprint');
$grids_db->save();

exit;
