
# Routines used by the hierarchy to communicate.

# These try fairly hard to cope with temporary communication problems.
# If they return an error, the situation is probably not recoverable. 

$Message_center::max_retries 		= 5;
$Message_center::log_all 		= 1;
$Message_center::delay_between_retries	= 1; # (seconds)

# send_message($messages,$log);
# $log is a Log object, and $messages is a ref to a list of lists.  Each
# individual list is [$host,$port,$header,$message_ref];
#
# Returns 1 if everything went ok,  0 otherwise.

sub send_messages
{
  package Message_center;
  my(@messages) = @{shift @_};
  my($log) = @_;
  my($retry,$message,$host,$port,$header,$comm_return,%done);
  my($successes) = 0;
  my($desired) = scalar(@messages);
  my %return_done;
  my $position;

  die "No log object in send_messages" unless $log;
  unless($desired > 0)
   {
    $log->warn("No messages to send in send_messages") ;
    return 0;
   }
  foreach $retry (1..$Message_center::max_retries)
   {
    $position = -1;
    last if $successes == $desired;
    sleep $Message_center::delay_between_retries if $retry > 1;
    foreach $message (@messages)
     {
      $position += 1;
      unless(defined $message && ref $message eq 'ARRAY')
       {
        $log->warn("send_messages called with nonsense: $message");
       }
      next if $done{$message};
      ($host,$port,$header,$body) = @$message;
      $log->warn("About to send $header to $host:$port") 
						if $Message_center::log_all;
      $comm_return = Comm::tcp_send($host,$port,$header,@$body);
      if(defined $comm_return && $comm_return eq 'true')
       {
        $done{$message} = 1;
        $return_done{$position} = 1;
        $successes++;
        $log->warn("$0\[$$\] SENT to $host:$port - $header "
	  .substr(join(' ',@$body),0,200)) if $Message_center::log_all;
       }
      else
       {
        $log->warn("$0 FAILURE to send $header to $host:$port - $comm_return");
        $return_done{$position} = 0;
       }
     }
   }
  return($successes == $desired,%return_done);
}

# receive_messages($requests,$log);
# $log is a Log object, and $requests is a ref to a list of lists.  Each
# individual list is [$host,$port], $host:$port is a combination
# we expect a response from

# Returns ($status,$replies) where status is 1 if everything ok and 0 if
# not, and $replies is a ref to a list of lists of 
# ($host,$port,$header,$body_ref);

# Note - we guarantee to return things in the order we received the requests.
# If our input lists contain things beyond just ($host,$port) we guarantee
# not to tread on them.

# Assumes all that if a supplied senders is mentioned twice, then it will
# reply to the two messages in the order they were sent out.  This is likely
# to be true if
#	1) communications are all over tcp
#	2) the module controller and software manager process messages in
# 	   the order received.

sub receive_messages
{
  package Message_center;
  my($request_ref,$log,$blocking) = @_;
  my($retry,$count,$host,$port,$header,$junk,$one_mesg_ref,$err);
  my($successes) = 0;

  $blocking = "blocking" unless defined $blocking;

  die "No log object in receive_messages" unless $log;

  unless(defined $request_ref && $request_ref && ref $request_ref eq 'ARRAY')
   {
    $err = 'Bad $request_ref argument in receive_messages: '.$request_ref;
    $log->warn($err);
    return (0,undef);
   }
  my($desired) = scalar(@$request_ref);
  unless($desired > 0)
   {
    $log->warn("No messages to receive in receive_messages") ;
    return (0,undef);
   }
  foreach $one_mesg_ref (@$request_ref)
   {
    unless(defined $one_mesg_ref && ref $one_mesg_ref eq 'ARRAY')
     {
      $err = 'Bad $one_mesg_ref argument in receive_messages: '
							.$one_mesg_ref;
      $log->warn($err);
      return (0,undef);
     }
   }

  my $return_ref = [1..$desired];
  my $m_ref = [1..$desired];
  my %done;
  my $i;
  # Initialize all positions to 0.
  for ($i = 0; $i < $desired; $i += 1)
   {     
    $done{$i} = 0;
   }
 

  foreach $count (0..$desired-1)
   {
    $m_ref->[$count] = [];
    # Get a reply;
    foreach $retry (1..$Message_center::max_retries)
     {
      ($junk,$host,$port,$header,@{$m_ref->[$count]}) = 
	#Comm::mesg_recv(5,undef,'tcp_only',$request_ref,undef);
	Comm::mesg_recv($blocking,undef,'tcp_only',$request_ref,undef);
	#Comm::mesg_recv('blocking',undef,'tcp_only',$request_ref,undef);
      last if defined $header;
      $log->warn("$0 Bad mesg recv in receive_messages"); 
    }
    # We received a request - find its position in our input
    my($position) = grep(("$host $port" eq "@{$request_ref->[$_]}[0..1]")
			&& !$done{$_}, (0..$desired-1));
    unless(defined $position)
     {
      # This pretty much means a fuckup in Comm::mesg_recv
      $log->warn("Received unexpected response in receive_messages: ");
      $log->warn(join('--',($junk,$host,$port,$header,@{$m_ref->[$count]})));
      #redo;
      #print STDERR ("Received unexpected response in receive_messages: \n");
     }
    else
     {
      $done{$position} = 1;

      # If we get here, we should be in good shape.
      $return_ref->[$position] = [$host,$port,$header,$m_ref->[$count]];
      $log->warn("$0\[$$\] RECEIVED $header from $host:$port - $header ".
       substr(join(' ',@{$m_ref->[$count]}),0,200)) if $Message_center::log_all;
      $successes++;
     }
   }
  return ($successes == $desired, $return_ref, %done);
}

package Message_center;

sub array_copy
{
  # This is gross.  There must be a better way.
  my($output_array) = [];
  foreach $val (@_)
   {push(@$output_array,$val);}
  return $output_array;
}

1;
