#!/pkg/bin/perl

# Class to compute the mean and variance of a series of observations.

# Usage:

# $mystat = new Stat_summary();
# $mystat->observe(1.0, 3.2, 7.9);
# $mystat->observe($obs);
# $variance = $mystat->variance();
# $mean = $mystat->mean();

package Stat_summary;
use strict;

sub new
{
  my($type) = @_;
  my $self = {};
  bless $self, $type;
}

sub observe
{
  my $self = shift; my $obs;

  foreach $obs (@_)
   {
    $self->{'count'}++;
    $self->{'total'} += $obs;
    $self->{'total_square'} += $obs*$obs;
   }
}

sub mean
{
  my $self = shift;
  return $self->{'total'}/$self->{'count'};
}

sub variance
{
  my $self = shift;
  my $mean = $self->{'total'}/$self->{'count'};
  return $self->{'total_square'}/$self->{'count'} - $mean*$mean;
}

sub mean_err
{
  my $self = shift;
  my $mean = $self->{'total'}/$self->{'count'};
  return sqrt(($self->{'total_square'}/$self->{'count'} - $mean*$mean)
		/$self->{'count'});
}

1;