package Test_script;
$total_count = 0;
$passed_count = 0;

package main;

# Delete old versions of our working area, and make ourselves a new work area.

sub initialize_tests
{
  package Test_script;
  @directories = @_;
  $test_dir = "$0.tempdir";
  system("rm -rf $test_dir");
  system("mkdir $test_dir");
  chomp($src = `pwd`);
  @directories = map("$src/$_",@directories);
  system("ln -s  @directories $src/*.pm $test_dir");
  chdir $test_dir;
}

sub var_diff_file
{
  package Test_script;
  my($variable,$file) = @_;
  
  my $contents = `cat $file`;
  return 0 if($variable eq $contents);
  return $variable.$contents;
}

# Compares the lines of a file to an array of patterns.
sub file_matches_patterns
{
  package Test_script;
  my($file,@patterns) = @_;
  
  open(FILE,$file) || die("Can't open $file in Test_script.pm\n");
  @contents = <FILE>;
  close(FILE);
  
  unless($#contents == $#patterns)
   {
    my $contents = @contents; my $patterns = @patterns;
    print STDERR "$contents file index but $patterns pattern index\n";
    return 0;
   } 
  
  my $ok = 1;
  foreach (0..$#contents)
   {
    unless($contents[$_] =~ /$patterns[$_]/)
     {
      print STDERR "$contents[$_] did not match /$patterns[$_]/\n";
      $ok = 0;
     }
   }
  return $ok;
}

sub save_to_file
{
  package Test_script;
  my($variable,$file) = @_;
  
  open(FILE,">$file");
  print FILE $variable;
  close(FILE);
}

sub perform_test
{
  package Test_script;
  ($expr,$name,$failure_message) = @_;
  
  if($expr)
   {
    $passed_count++;
    $total_count++;
    print "$total_count: Passed $name\n";
   }
  else
   {
    $total_count++;
    print "$total_count: Failed $name:\n$failure_message\n\n";
   }
}

sub report_test_results
{
  package Test_script;
  print "\nPassed $passed_count tests out of $total_count.\n\n";
}

1;