#!/pkg/bin/perl

# This file contains functions to put one or more packets in
# the common GrIDS format in one packet, and to extract them
# from this format.

package common_format;

# This packages multiple packets of the same type into
# one packet.  The first argument is the type, and following
# arguments are the packets.
sub packsame {
  my $type=shift;
  my $packed;

  while (@_) {
    $packed.=$type."\xff".shift(@_)."\xff";
  }

  return $packed;
}

# This packages multiple packets of different types
# into one packet.  The first and alternating arguments
# are the type, and the other arguments are the packets
# for the preceding type.
sub packdiff {
  my $packed = join('\xff',@_);
  $packed.='\xff';
}

# This unpacks possibly multiple packets of possibly
# multiple types and returns the types and packets.
# The return value is a list where the first and alternating
# values are the types, and the other values are the
# appropriate packets.
sub unpack {
    split ("\xff");
}
