#!/pkg/bin/perl -w

# $Id: add_report.pl,v 1.7 1997/02/01 20:18:30 hoagland Exp $

# This files the add_report function to try to add a report to
# Rulesets.

use Ruleset;

# add_report is called when the buffer is done with the report and it
# is ready to (potentially) be added to graphs in rulesets; this adds
# the report to the rulesets that want it
#
# add_report: report x Ruleset x Ruleset x ... -> 
#
# e.g. &add_report($report,@rulesets);
#
sub add_report {
  my($report,@rulesets)= @_;
  my($rs);

  foreach $rs (@rulesets) {
    if ($rs->test_preconds($report)) {
      &log_acceptance($rs->name,$report->id) if $rs->debug;
      $rs->add_report($report);
    } else {
      &log_rejectance($rs->name,$report->id) if $rs->debug;
    }
  }
}

1;
