#!/pkg/bin/perl -w

# $Id: query.pl,v 1.12 1997/02/01 20:18:50 hoagland Exp $

# This file contains functions to perform a graph query.

require 'execute.pl';
#require 'dump.pl';

use Ruleset;

# do_query finds the Graphs in all of the Rulesets which match the
# conditions specified in the query text and returns it as text (a
# composite graph) unless there is an error in which case an error
# message is returned.
#
# do_query: query_text -> text
#
# e.g. do_query($query);
#
sub do_query {
  my(@errors,$mess);
  if (@errors= &check_query($_[0],1)) {
    $mess= "The following errors were found in the query:\n".join("\n",@errors)."\n";
    warn $mess;
    return $mess;
  }
  my(@tests)= grep($_,split(/\s*;\s*/,$_[0]));
  # @tests are now single non-empty rules

  my($rs,$graph);
  my(@graphs,@good_graphs)= ();

  foreach $rs (Ruleset->all) {
    $rs->check_timeouts; # see if any graphs should go away
    push(@graphs,$rs->graphs);
  }

  foreach $graph (@graphs) {
    push(@good_graphs,$graph) if &test_graph($graph,@tests);
  }

  #foreach (@good_graphs) { &printref($_); print "\n"; }
  return "digraph \"composite\" {\n  ".join("\n  ",map($_->dot_text(1),@good_graphs))."\n}\n";
}


# test_graph returns a boolean value indicating whether or not a given
# graph passes the given tests.  The tests are rules such as those
# found in the rulesets except that the set of attributes is
# implicitly the graph's global ones.
#
# test_graph: Graph x {rule} -> boolean
#
# e.g. if (test_graph($graph,@tests)) {
#
sub test_graph {
  my($graph,@tests)= @_;
  my($node,$edge,$test);

  foreach $test (@tests) {
    my(%bindings)= ();
    my($count)= 0;
    while ($test =~ s/\"([^\"]*)\"\.node\b/n$count.node/) {
      $bindings{"n$count.node"}= $graph->node($1);
      $count++;
    }
    $count= 0;
    while ($test =~ s/\"([^\"]*)\"\.edge\b/e$count.edge/) {
      my(@edges)= $graph->edge_from_to(split(/\s*->\s*/,$1));
      $bindings{"e$count.edge"}= shift(@edges);
      $count++;
    }
    return 1 if &execute::evaluate($test,'query test',
				   '' => $graph,
				   'global' => $graph,
				   %bindings);
  }
  return 0;
}
