# $Id: exemon.rs,v 1.6 1997/02/01 19:27:30 hoagland Exp $

ruleset exemon;
buffer 0;
timeout 1000;

macros {
COLOR="red";
}

attribute declarations {
program_name scalar;
name scalar;
coloar scalar;
username scalar;
real_username scalar;
ctype scalar;
id scalar;
programs set;
}

node precondition defined(new.node.program_name);

edge precondition defined(new.edge.ctype) && new.edge.ctype eq "rsh";

report global rules {
res.global.programs = {};
}

report node rules {
res.node.name = new.node.name;
res.node.program_name = new.node.program_name;
res.global.programs = {res.global.programs,new.node.program_name};
defined(new.node.program_name) && assign_primitive("res.node","color",COLOR);
res.node.username = new.node.real_username;
res.global.username = new.node.real_username;
}

report edge rules {
res.edge.ctype = new.edge.ctype;
res.edge.id = new.edge.id;
res.source.username = new.edge.local_login_name;
res.dest.username = new.edge.remote_login_name;
}

global rules {
res.global.programs = {new.global.programs,cur.global.programs};
}

node rules {
res.node.combine = new.node.username eq cur.node.username;
res.node.name = new.node.name;
new.node.color eq COLOR && assign_primitive("res.node","color",COLOR);
cur.node.color eq COLOR && assign_primitive("res.node","color",COLOR);
}

edge rules {
res.edge.combine = 1;
}

assessments {
!empty(res.global.programs) ==> report_graph(3,res.global.username);
}
