# $Id: simu_sweep.rs,v 1.2 1997/02/01 19:26:37 hoagland Exp $

ruleset sweep;
buffer 0;
timeout 300;

macros {
T=200;
}

attribute declarations {
end scalar;
name scalar;
root scalar;
simu set;
}

node precondition defined(new.node.edges);

edge precondition 1;

report global rules {
}

report node rules {
res.global.root = new.node.name;
res.global.edges = cond(defined(new.node.edges),{new.node.edges},{});
}

report edge rules {
res.global.edges = {new.edge.id,res.global.edges};
res.global.root = new.source.name;
res.source.time = new.edge.time;
res.dest.time = new.edge.time;
res.edge.time = new.edge.time;
res.edge.simu = [new.edge.simu];
}

global rules {
res.global.edges = {new.global.edges,cur.global.edges};
res.global.root = cur.global.root;
}

node rules {
res.node.combine = new.global.root eq cur.global.root;
res.node.time = max({new.node.time,cur.node.time});
}

edge rules {
res.edge.combine = 0;
res.edge.time = max({new.edge.time,cur.edge.time});
res.edge.simu = [cur.edge.simu,new.edge.simu];
}

assessments {
report_threshold(res.global.nnodes,1,1,res.global.root) ==> report_graph(1,"sweep detected");
}
