# $Id: sweep.rs,v 1.9 1997/02/12 07:20:18 crawford Exp $

ruleset sweep;
buffer 0;
timeout 2000;

macros {
}

attribute declarations {
count scalar;
ctype scalar;
end scalar;
local_login_name scalar;
name scalar;
root scalar;
}

node precondition 0;

edge precondition defined(new.edge.ctype) && new.edge.ctype eq "rsh";
     #   && new.edge.local_login_name eq "grids";

report global rules {
}

report node rules {
res.node.count = new.node.count;
defined(new.node.count) || assign_primitive("res.node","count",1);
res.node.name = new.node.name;
res.global.count = res.global.count + res.node.count;
}

report edge rules {
res.edge.ctype = new.edge.ctype;
res.edge.local_login_name = new.edge.local_login_name;
res.source.end = "source";
res.global.root = new.source.name;
res.dest.end = "dest";
}

global rules {
res.global.count = new.global.count + cur.global.count;
}

node rules {
res.node.combine = new.node.end eq "source" && cur.node.end eq "source";
res.node.end = "source";
res.edge.name = new.edge.name;
}

edge rules {
res.edge.combine = 1;
}

assessments {
report_threshold(res.global.count,5,3, res.global.root::min(gids)) ==> report_graph(3,"sweep with "::res.global.count::" edges");
}
