# $Id: sweep_detector_single_department.rs,v 1.3 1997/02/01 19:25:23 hoagland Exp $

ruleset sweep_detector_single_department;
buffer 0;
timeout 10;

macros {
}

attribute declarations {
ctype scalar;
dport scalar;
id scalar;
local_login_name scalar;
remote_login_name scalar;
rsh_command scalar;
sport scalar;
stage scalar;
status scalar;
end scalar;
}

node precondition 0;

edge precondition defined(new.edge.ctype) && new.edge.ctype eq "rsh";

report global rules {
res.global.users = {};
res.global.commands = {};
res.global.hosts = {};
}

report node rules {
res.global.hosts = {res.global.hosts, new.node.name};
res.node.name = new.node.name;
}

report edge rules {
res.global.users = {res.global.users, new.edge.local_login_name, new.edge.remote_login_name};
res.global.commands = {res.global.commands, new.edge.rsh_command};
res.edge.dport = new.edge.dport;
res.edge.id = new.edge.id;
res.edge.sport = new.edge.sport;
res.edge.stage = new.edge.stage;
res.edge.status = new.edge.status;
new.source.end = "source";
new.dest.end = "dest";
}

global rules {
res.global.hosts = {new.global.hosts, cur.global.hosts};
res.global.commands = {new.global.commands, cur.global.commands};
res.global.users = {new.global.users, cur.global.users};
}

node rules {
res.node.combine = new.source.end == "source" && new.dest.end == "source";
}

edge rules {
res.edge.combine = 1;
}

assessments {
res.global.nnodes == 1 ==> report_graph(2,"Small graph");
res.global.nnodes == 2 ==> report_graph(3,"Medium graph");
res.global.nnodes == 3 ==> report_graph(4,"Large graph");
}
