#!/pkg/bin/perl -w


#-----------------------------------------------------------------------------
# $Id: dotedit.pl,v 1.2 1996/08/16 06:39:04 templets Exp $
#
# simple utility to edit and display graphs using dot
#
# - to do:
#     * add disapearing scrollbars to graph window 
#     * add enable/disable of zoom_in/zoom_out when limits have been reached
#     * expand usage of dot attributes
#
#-----------------------------------------------------------------------------


use Tk;
use Tk::DropSite qw(Sun);
use Tk::DragDrop qw(Sun);
require Tk::TextUndo;
require Tk::FileSelect;
require Tk::Menubar;
use Tk::ErrorDialog;
use strict;

my $MW      = MainWindow->new();
my $menuBar = $MW->Menubar;
my $scale   = 2;
my $MMfont  = '-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*';


$MW->configure(         -title  => 'Edit Window',
			-height => '15c',
                        -width  => '20c',
                        -bg     => 'white' );					
$MW->geometry( '1000x700' );

my $canvas = $MW->Canvas( 
                -background => '#fff5e1',
                -scrollregion => [ '0i', '0i', '20i', '20i' ],
		-width =>  '10c',
	      	-height => '15c',
		-relief => 'sunken'
             );
$canvas->pack( -expand => 'yes', -fill => 'both', -side => 'right' );




#-------------------------------------------------------------------------------
# Setup the scroll bars for graph window ---------------------------------------
#-------------------------------------------------------------------------------
my $yscroll = $canvas->Scrollbar( -command => [ 'yview', $canvas ] );
my $xscroll = $canvas->Scrollbar( -command => [ 'xview', $canvas ], -orient => 'horiz' );
$canvas->configure( -yscrollcommand=>[ 'set', $yscroll ]);
$canvas->configure( -xscrollcommand=>[ 'set', $xscroll ]);
$yscroll->pack( -side => 'right',  -fill => 'y' );
$xscroll->pack( -side => 'bottom', -fill => 'x' );



$MW->optionAdd('*TextUndo.Background' => 'white' );



my $fileSelect  = $MW->Component(FileSelect => 'fs',
				 -width => '10c', 
				 -height => '15c',
				 'accept' => sub 
				         { my $file = shift ; 
					   return 0 if (-s $file && !(stat(_))[12]);
					   return (-r $file) && (-T $file);  
				         },
				 Name    => 'fs', 
				 -filter => '*.dot');


#-------------------------------------------------------------------------------
# Setup the text-edit region                       -----------------------------
#-------------------------------------------------------------------------------
my $text1 = $MW->Scrolled('TextUndo', -wrap => 'none', -width=>'50' );

my $dragNDrop = $text1->DragDrop(-event => '<Meta-B1-Motion>');
$dragNDrop->configure(-startcommand => 
               sub
                {
                 return 1 unless (eval { $text1->tagNextrange(sel => '1.0','end')});
                 $dragNDrop->configure(-text => $text1->get('sel.first','sel.last')); 
                });
                
$text1->DropSite(-motioncommand => 
              sub 
               { my ($x,$y) = @_;
                 $text1->markSet(insert => "\@$x,$y");
               },
              -dropcommand => 
              sub 
               { my ($seln,$x,$y) = @_;
                 $text1->markSet(insert => "\@$x,$y");
                 $text1->insert(insert => $text1->SelectionGet(-selection => $seln));
               }
             );

$text1->pack(-expand =>'no', -fill => 'both', -side=>'left' );
$text1->Load($ARGV[0]) if (@ARGV);


$menuBar->Menubutton(-text => '~File', -menuitems => 
                  [[Button => '~Open',
			   -command => sub { 
			                    my $file = $fileSelect->Show(-popover => $MW);
			                    $text1->Load($file) if (defined $file);
					    print "-- NO FILE --\n" if (!defined $file);
					    $text1->pack(-expand => 1, -fill => 'both' );
			                   }
		  ]]);

$menuBar->Menubutton(-text => '~File', -menuitems => 
		  [['Button' => '~Save', -command => [ $text1 , 'Save' ]],
		   ['Button' => '~Empty', -command => [ $text1,'delete','1.0','end']],
		   ['Button' => '~Pass to dot', -command => [ \&show_graph, $text1, $canvas ]],
		   ['Button' => '~Quit', -command => [ 'destroy',$MW ]]
		   ]);

$menuBar->Menubutton(-text => '~Zoom', -menuitems => 
		  [['Button' => '~In',  -command => sub { $scale /= 2 if $scale > .5; 
							  &show_graph($text1, $canvas); }],
		   ['Button' => '~Out', -command => sub { $scale *= 2 if $scale < 4; 
							  &show_graph($text1, $canvas); }]
		   ]);

show_graph($text1,$canvas) if (@ARGV);

MainLoop;


sub show_graph {
  my ($t,$c) = @_;    #- input parameters: 
                      #    $t is the text_edit widget, 
                      #    $c is the canvas widget

  my $margin = 0.25;  #- margin around graph (in inches )
  my $cmd;            #- constructed pTk string command for eval
  my $text_in;        #- the text specifying the graph(in dot format)
  my $text_out;       #- the plaintext specification created by passing $text_in to dot

  $c->delete('all');  #- clear the canvas of all previously drawn objects

  #- extract the text from the textedit widget -----  
  $text_in = $t->get('1.0','end');

  #- insert dot commands to force the graph into the expected default mode -----
  $text_in =~ s/{/{graph [rankdir=LR];node [shape=ellipse, fontname=Helvetica, fontsize=24];/;

  #->> Note: the following uses a shell trick -----
  $text_out = `dot -Tplain<<EOF\n$text_in\nEOF\n`;

  print "$text_out\n\n";
#-----------------------------------------------------------------------------	
#- convert each dot plaintext statement into its pTk equivalent and create 
#-   the object on the canvas.
#-   		   
#-----------------------------------------------------------------------------	
  foreach (split('\n',$text_out)) {

  #- process 'node' statements -----
    /^node/ && do {
      my ($node, $name, $x, $y, $xsize, $ysize, $label, $style, $shape, $color) = split;

    #- scale and shift the anchor position for the node -----
      $x = ($x/$scale)+$margin; 
      $y = ($y/$scale)+$margin;

    #- calculate left,top and right,bottom from center + length,width -----
      $xsize /= 2*$scale; $ysize /= 2*$scale;
      my $x1 = ($x - $xsize).'i';
      my $y1 = ($y - $ysize).'i';
      my $x2 = ($x + $xsize).'i';
      my $y2 = ($y + $ysize).'i';

    #- convert dot shapenames to Tk shapenames -----
      $shape = 'rectangle' if $shape eq 'box';
      $shape = 'oval' if $shape eq 'ellipse';
       
    #- create the pTk command to create the node -----
      $cmd = " \$c->create(qw($shape $x1 $y1 $x2 $y2 -outline $color -fill white -tags node ));
	      \$c->create(qw(text $x"."i $y"."i -anchor center),
	      -text => \$label, -justify => 'center', -font=>\$MMfont, -tags => 'node');\n";
      
    #- create the node -----
      eval $cmd || die @!;

      next;
    };
			

  #- process 'edge' statements -----
    /^edge/ && do {
      my ($edge, $tail, $head, $n, $rest) = split(' ',$_,5);
      
    #- calculate the number of list elements used for curve control points,
    #-  and extract all remaining parameters from the dot plaintext command   
      $n = $n * 2 - 1;
      my @control_pts = split(' ',$rest);

    #- extract line attributes (just after actual control points) -----
      my ($style, $color) = @control_pts[$n+1..$n+2];

    #- scale and adjust length of last segment of edge so that it reaches the dest. node -----
      @control_pts = map(($_/$scale)+$margin, @control_pts[0 .. $n] );
      @control_pts[$n]   += (@control_pts[$n  ] <=> @control_pts[$n-2])*(0.1/$scale);
      @control_pts[$n-1] += (@control_pts[$n-1] <=> @control_pts[$n-3])*(0.1/$scale);
       
      my $width; 
      $width = 2 if $style eq 'solid';
      $width = 5 if $style eq 'bold';
    #- create the pTk command to create the edge -----
      $cmd = " \$c->create(qw(line ".join(' ', map("$_".'i', @control_pts[0 .. $n]))." -smooth on -arrow last -tags edge -fill $color -width $width ));\n";

    #- create the edge -----
      eval $cmd || die @!;

      next;
    };


  #- process 'graph' statements -----
    /^graph/ && do {
      my ($graph, $sf, $xsize, $ysize) = split;
      
    #- scale and shift the length and width of the graph ----
      $xsize = (($xsize/$scale)+$margin*2); 
      $ysize = (($ysize/$scale)+$margin*2); 
    
    #- set scroll region to include just the graph, and increase size of window to show the graph -----  
      $c->configure(-scrollregion => [ '0i', '0i', $xsize.'i', $ysize.'i' ],
		    -width  => $xsize.'i',
		    -height => $ysize.'i'
		   );
     
      next;
    };

    last if /^stop/;
  }
  
} #show_graph()
