#!/pkg/bin/perl -w

# $Id: grids,v 1.42 1997/07/02 05:40:34 crawford Exp $

# This script sets up a simple hierarchy as a sample to begin with.

use Hierarchy_interface;
use Test_script;
use Clog;
use Mod_utility;
use Grdbm;
#
#-----------------------------------------------------------------------
$user = "root";
$pass = "enter_now";

local $grids_db = $Hierarchy_interface::grids_db; # Hierarchy configuration

my ($ohs_host,$ohs_port) = split(/:/,$Hierarchy_interface::ohs_location);

$log = new Clog('grids_test','N/A',"grids.test.log"); # Set up our log
$log->{'central_log'} = 0; # No central logging - presently broken.

($ok, $h) 
     = new Hierarchy_interface($user,$pass,'ROOT',$log,'comm','main::FILE');


my %sniffers = ( 
		 "ROOT"   =>         "spurr.cs.ucdavis.edu",
                );
my ($snif_dept,$snif_host);
my $snif_action = 'START';
$snif_action = 'KILL' if ($ARGV[0] eq '-kill');

# Start a sniffer in each agg dept

foreach $snif_dept ( keys %sniffers )
{
  $snif_host = $sniffers{$snif_dept};
  print "Ready to $snif_action sniffer on $snif_host.\n";
  my $agg = "$h->{'hierarchy'}{$snif_dept}->{'aggregator_host'}:".
            "$h->{'hierarchy'}{$snif_dept}->{'aggregator_port'}"; 
  my ($ok,$rslt) = $h->set($snif_host,'module_controller',$snif_dept,
				   'mc_command',$snif_action,
				   'mod_module','sniffer',
				   'mod_version','v.bin',
				   'mod_department',$snif_dept,
				   'parent_aggregator',$agg );
  $log->warn("done starting sniffer in dept $snif_dept!\n".
             " ok=$ok\nrslt=$rslt\n") unless $ok;

# For each dept, send it's engine alerts to a file.

  if ($snif_action eq 'START') {
      $agg = $h->{'hierarchy'}{$snif_dept}->{'aggregator_host'};
      $alert_file = "log/$snif_dept.alerts";
      ($ok, $rslt) = $h->set($agg,'engine',$snif_dept,
			     "alert_recipients{$alert_file}",1);
      $log->warn("After setting alert file for dept $snif_dept!\n".
		 " ok=$ok\nrslt=$rslt\n") unless $ok;
  }
  print "Done $snif_action ING sniffer on $snif_host.\n";
#  sleep 10;
}

$h->{'hierarchy'}->save("$ENV{'GRIDSPATH'}/log/output_hierarchy",
                            'prettyprint');
$grids_db->save();

exit;
